<?php

class ControllerExtensionModulemodulus extends Controller
{
    protected $version = '1.0.0';
    protected $error = [];

    public function index()
    {
        $this->load->language('extension/module/modulus');

        $this->document->setTitle(strip_tags($this->language->get('heading_title')));

        $this->load->model('extension/module/modulus');

        $this->getList();
    }

    public function settings()
    {
        $this->load->language('extension/module/modulus');

        $this->document->setTitle(strip_tags($this->language->get('heading_title')));

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->load->model('setting/setting');

            $this->model_setting_setting->editSetting('modulus_settings', $this->request->post);

            $this->model_setting_setting->editSetting('module', ['module_modulus_status' => !empty($this->request->post['module_modulus_status']) ? '1' : '0']);
            
            $this->model_setting_setting->editSetting('module', ['module_modulus_backinstock' => !empty($this->request->post['module_modulus_backinstock']) ? '1' : '0']);

          //  $this->model_setting_setting->editSetting('module', ['module_modulus_timelimit' => !empty($this->request->post['module_modulus_timelimit']) ? '1' : '0']);
            
            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getList();
    }

    /*
    public function testsms()
    {
        $this->load->language('extension/module/modulus');

        $this->document->setTitle(strip_tags($this->language->get('heading_title')));

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->load->model('setting/setting');


           

            $this->session->data['success'] = $this->language->get('text_test_send');

           // $this->response->redirect($this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=testsms', true));
        }

        $this->getList();
    }
    */

    public function testsms() {
        $this->load->language('extension/module/modulus');
        $this->document->setTitle(strip_tags($this->language->get('heading_title')));

       
    
    
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
           
            
            $this->load->model('setting/setting');

            require_once(DIR_SYSTEM . 'library/modulus/modulusSend.php');

            $smsSender = new modulusSend();

          
            $testPhoneNumber = $this->request->post['modulus_testsms_phone'];
            $testMessage = $this->request->post['modulus_testsms_message'];
    

            $smsSender->setUrl($this->config->get('modulus_settings_api_url'));
            $smsSender->setSenderId($this->config->get('modulus_settings_senderid')); 
            $smsSender->setApiToken($this->config->get('modulus_settings_api_token')); 
            $smsSender->setChannel($this->config->get('modulus_settings_channel')); 
           
         

            $smsSender->addPhone($testPhoneNumber);
            $smsSender->addSmsMessage($testMessage);
 
          
          //  $dataToSend = $smsSender->getData();

            list($httpCode, $response) = $smsSender->send();

            var_dump( 'Response:' . $response);
             
            $responseData = json_decode($response, true); // Decode the JSON response into an array
            $message = $responseData['messages'][0]['status']['message']; 

            if(!$message){
                $message = $responseData['message'];
            }

            $this->session->data['success'] = $message ;

            $this->response->redirect($this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=testsms', true));

        }
    
      
    }

    public function SendBulkModulusSMS() {
        $this->load->language('extension/module/modulus');
        $this->document->setTitle(strip_tags($this->language->get('heading_title')));
        $this->load->model('setting/setting');
        $this->load->model('extension/module/modulus');
        $this->load->model('customer/customer');
        $timelimit =  $this->config->get('modulus_settings_timelimit');
       
     
    

        $customers_info = [];

        foreach($this->request->post['sms_phone'] as $phone) {
            $phone_array = explode('-', $phone);
            $customers_info[] = array(  
                'customer_phone' => $phone_array[1],
                'customer_id' => $phone_array[0]
            );
        }



    foreach($customers_info as $c){

        $PhoneNumber = $c['customer_phone'];
        $cus_id = $c['customer_id'];

        $customer_info = $this->model_customer_customer->getCustomer($cus_id);

        $Message = $this->request->post['sms_message'];
        
        $Message = str_replace("{first_name}", $customer_info['firstname'], $Message);
        $Message = str_replace("{last_name}", $customer_info['lastname'], $Message);
        
        if ($PhoneNumber && substr($PhoneNumber, 0, 3) !== '+30' || substr($PhoneNumber, 0, 4) !== '0030') {
           
            if (substr($PhoneNumber, 0, 1) === '0') {
                $PhoneNumber = substr($PhoneNumber, 1);
            }
            $PhoneNumber = '+30' . $PhoneNumber;
        }

      
        $hourRanges = array(
            'Monday' => array('from' => $this->config->get('modulus_settings_monday_from'), 'to' => $this->config->get('modulus_settings_monday_to')),
            'Tuesday' => array('from' => $this->config->get('modulus_settings_tuesday_from'), 'to' => $this->config->get('modulus_settings_tuesday_to')),
            'Wednesday' => array('from' => $this->config->get('modulus_settings_wednesday_from'), 'to' => $this->config->get('modulus_settings_wednesday_to')),
            'Thursday' => array('from' => $this->config->get('modulus_settings_thursday_from'), 'to' => $this->config->get('modulus_settings_thursday_to')),
            'Friday' => array('from' => $this->config->get('modulus_settings_friday_from'), 'to' => $this->config->get('modulus_settings_friday_to')),
            'Saturday' => array('from' => $this->config->get('modulus_settings_saturday_from'), 'to' => $this->config->get('modulus_settings_saturday_to')),
            'Sunday' => array('from' => $this->config->get('modulus_settings_sunday_from'), 'to' => $this->config->get('modulus_settings_sunday_to'))
        );
    
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
    
            $send_message = true;
            if ($timelimit == 1) {
                date_default_timezone_set('Europe/Athens');
                $currentDay = date('l');
                $currentHour = date('H:i');
                $hasHourRanges = false;
    
                  foreach ($hourRanges as $day => $hourRange) {
                    if ($hourRange['from'] != '' && $hourRange['to'] != '') {
                      
                        $hasHourRanges = true;
    
                        if ($day == $currentDay) {
                            $fromTime = strtotime($hourRange['from']);
                            $toTime = strtotime($hourRange['to']);
                            $currentTime = strtotime($currentHour);

                            if ($currentTime >= $fromTime && $currentTime <= $toTime) {
                              
                                $send_message = true;
                                break;
                            } else {
                            
                                $send_message = false;
                            }
                        }
                    }
                }

                if (!$hasHourRanges) {
                    $send_message = true;
                }
            } else {
                $send_message = true;
            }

           
    
            if ($send_message == true) {
                require_once(DIR_SYSTEM . 'library/modulus/modulusSend.php');
               
                $smsSender = new modulusSend();
    
               

         
                $order_status_id = 0;
               
                $smsSender->setUrl($this->config->get('modulus_settings_api_url'));
                $smsSender->setSenderId($this->config->get('modulus_settings_senderid'));
                $smsSender->setApiToken($this->config->get('modulus_settings_api_token'));
                $smsSender->setChannel($this->config->get('modulus_settings_channel'));
                $smsSender->setCallback($this->url->link('extension/module/modulus/callback', '', true));
               
    
                $smsSender->addPhone($PhoneNumber);
                $smsSender->addSmsMessage($Message);
    
                list($httpCode, $response) = $smsSender->send();

             
    
                if ($httpCode == 200) {
                    
                    $responseObject = json_decode($response);
                    $messageId = $responseObject->messages[0]->messageId;
                    $callbackcode = $responseObject->messages[0]->status->code;
                    $callbackmessage = $responseObject->messages[0]->status->message;
    
                    $this->model_extension_module_modulus->updateLogscus($cus_id, $PhoneNumber, $Message, $order_status_id, $messageId, $callbackcode, $callbackmessage);
                   
                    $json['success'] = $callbackmessage;
                } else {
                    $json['error'] = 'SMS could not be sent. Response code: ' . $response;
                }
    
                $this->response->addHeader('Content-Type: application/json');
                $this->response->setOutput(json_encode($json));

            } else{

                $this->model_extension_module_modulus->saveForLaterSendingCus($PhoneNumber, $Message, $cus_id);
                    
                $json['success'] = 'Message saved for later sending.';
               
                
                $this->response->addHeader('Content-Type: application/json');
                $this->response->setOutput(json_encode($json));

            }
        }
      }
    }


    public function SendModulusSMS() {
        $this->load->language('extension/module/modulus');
        $this->document->setTitle(strip_tags($this->language->get('heading_title')));
        $this->load->model('sale/order');
        $this->load->model('setting/setting');
        $this->load->model('extension/module/modulus');
        $timelimit =  $this->config->get('modulus_settings_timelimit');
        $this->load->model('sale/order');
        $cus_id = $this->request->post['modulus_cus_id'];
        $order_id = $this->request->post['modulus_order_id'];
        $order_info = $this->model_sale_order->getOrder($order_id);
        $hourRanges = array(
            'Monday' => array('from' => $this->config->get('modulus_settings_monday_from'), 'to' => $this->config->get('modulus_settings_monday_to')),
            'Tuesday' => array('from' => $this->config->get('modulus_settings_tuesday_from'), 'to' => $this->config->get('modulus_settings_tuesday_to')),
            'Wednesday' => array('from' => $this->config->get('modulus_settings_wednesday_from'), 'to' => $this->config->get('modulus_settings_wednesday_to')),
            'Thursday' => array('from' => $this->config->get('modulus_settings_thursday_from'), 'to' => $this->config->get('modulus_settings_thursday_to')),
            'Friday' => array('from' => $this->config->get('modulus_settings_friday_from'), 'to' => $this->config->get('modulus_settings_friday_to')),
            'Saturday' => array('from' => $this->config->get('modulus_settings_saturday_from'), 'to' => $this->config->get('modulus_settings_saturday_to')),
            'Sunday' => array('from' => $this->config->get('modulus_settings_sunday_from'), 'to' => $this->config->get('modulus_settings_sunday_to'))
        );
    
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
    
            $send_message = true;
            if ($timelimit == 1) {
                date_default_timezone_set('Europe/Athens');
                $currentDay = date('l');
                $currentHour = date('H:i');
                $hasHourRanges = false;
    
                  foreach ($hourRanges as $day => $hourRange) {
                    if ($hourRange['from'] != '' && $hourRange['to'] != '') {
                      
                        $hasHourRanges = true;
    
                        if ($day == $currentDay) {
                            $fromTime = strtotime($hourRange['from']);
                            $toTime = strtotime($hourRange['to']);
                            $currentTime = strtotime($currentHour);

                            if ($currentTime >= $fromTime && $currentTime <= $toTime) {
                              
                                $send_message = true;
                                break;
                            } else {
                            
                                $send_message = false;
                            }
                        }
                    }
                }

                if (!$hasHourRanges) {
                    $send_message = true;
                }
            } else {
                $send_message = true;
            }

           
    
            if ($send_message == true) {
                require_once(DIR_SYSTEM . 'library/modulus/modulusSend.php');
               
                $smsSender = new modulusSend();
    
                $PhoneNumber = $this->request->post['sms_phone'];
                $Message = $this->request->post['sms_message'];
                $order_id = $this->request->post['modulus_order_id'];
                $order_info = $this->model_sale_order->getOrder($order_id);
                $order_status_id = $this->request->post['modulus_order_status_id'];
                $smsSender->setUrl($this->config->get('modulus_settings_api_url'));
                $smsSender->setSenderId($this->config->get('modulus_settings_senderid'));
                $smsSender->setApiToken($this->config->get('modulus_settings_api_token'));
                $smsSender->setChannel($this->config->get('modulus_settings_channel'));
                $smsSender->setCallback($this->url->link('extension/module/modulus/callback', '', true));
                $Message = str_replace("{first_name}", $order_info['firstname'], $Message);
                $Message = str_replace("{last_name}", $order_info['lastname'], $Message);
                $Message = str_replace("{order_id}", $order_info['order_id'], $Message);
                $Message = str_replace("{order_total}", $order_info['total'], $Message);
    
                $smsSender->addPhone($PhoneNumber);
                $smsSender->addSmsMessage($Message);
    
                list($httpCode, $response) = $smsSender->send();

             
    
                if ($httpCode == 200) {
                    
                    $responseObject = json_decode($response);
                    $messageId = $responseObject->messages[0]->messageId;
                    $callbackcode = $responseObject->messages[0]->status->code;
                    $callbackmessage = $responseObject->messages[0]->status->message;
    
                    if ($order_id > 0) {
                        $this->model_extension_module_modulus->updateLogs($order_id, $PhoneNumber, $Message, $order_status_id, $messageId, $callbackcode, $callbackmessage);
                    } else if ($cus_id > 0) {
                        $this->model_extension_module_modulus->updateLogscus($cus_id, $PhoneNumber, $Message, $order_status_id, $messageId, $callbackcode, $callbackmessage);
                    }
                    
                    $json['success'] = $callbackmessage;
                } else {
                    $json['error'] = 'SMS could not be sent. Response code: ' . $response;
                }
    
                $this->response->addHeader('Content-Type: application/json');
                $this->response->setOutput(json_encode($json));

            } else{
                
                $PhoneNumber = $this->request->post['sms_phone'];
                $Message = $this->request->post['sms_message'];
                $Message = str_replace("{first_name}", $order_info['firstname'], $Message);
                $Message = str_replace("{last_name}", $order_info['lastname'], $Message);
                $Message = str_replace("{order_id}", $order_info['order_id'], $Message);
                $Message = str_replace("{order_total}", $order_info['total'], $Message);
                $order_id = $this->request->post['modulus_order_id'];
                $order_info = $this->model_sale_order->getOrder($order_id);
                $order_status_id = $this->request->post['modulus_order_status_id'];
                if ($order_id > 0) {
                    
                    $this->model_extension_module_modulus->saveForLaterSending($PhoneNumber, $Message, $order_id, $order_status_id);
                    $json['success'] = 'Message saved for later sending.';
                } elseif ($cus_id > 0) {
                    
                    $this->model_extension_module_modulus->saveForLaterSendingCus($PhoneNumber, $Message, $cus_id);
                    
                    $json['success'] = 'Message saved for later sending.';
                }
                
                $this->response->addHeader('Content-Type: application/json');
                $this->response->setOutput(json_encode($json));

            }
        }
    }

    public function sendPendingMessages() {
        $this->load->language('extension/module/modulus');
        $this->document->setTitle(strip_tags($this->language->get('heading_title')));
        $this->load->model('setting/setting');
        $this->load->model('extension/module/modulus');

     
    
        $timelimit = $this->config->get('modulus_settings_timelimit');
        $hourRanges = array(
            'Monday' => array('from' => $this->config->get('modulus_settings_monday_from'), 'to' => $this->config->get('modulus_settings_monday_to')),
            'Tuesday' => array('from' => $this->config->get('modulus_settings_tuesday_from'), 'to' => $this->config->get('modulus_settings_tuesday_to')),
            'Wednesday' => array('from' => $this->config->get('modulus_settings_wednesday_from'), 'to' => $this->config->get('modulus_settings_wednesday_to')),
            'Thursday' => array('from' => $this->config->get('modulus_settings_thursday_from'), 'to' => $this->config->get('modulus_settings_thursday_to')),
            'Friday' => array('from' => $this->config->get('modulus_settings_friday_from'), 'to' => $this->config->get('modulus_settings_friday_to')),
            'Saturday' => array('from' => $this->config->get('modulus_settings_saturday_from'), 'to' => $this->config->get('modulus_settings_saturday_to')),
            'Sunday' => array('from' => $this->config->get('modulus_settings_sunday_from'), 'to' => $this->config->get('modulus_settings_sunday_to'))
        );
    

       
            $send_message = true;
            if ($timelimit == 1) {
                date_default_timezone_set('Europe/Athens');
                $currentDay = date('l');
                $currentHour = date('H:i');
                $hasHourRanges = false;
    
                foreach ($hourRanges as $day => $hourRange) {
                    if ($hourRange['from'] != '' && $hourRange['to'] != '') {
                        $hasHourRanges = true;
                        if ($day == $currentDay) {
                            $fromTime = strtotime($hourRange['from']);
                            $toTime = strtotime($hourRange['to']);
                            $currentTime = strtotime($currentHour);
                            if ($currentTime >= $fromTime && $currentTime <= $toTime) {
                                $send_message = true;
                                break;
                            } else {
                                $send_message = false;
                            }
                        }
                    }
                }
                if (!$hasHourRanges) {
                    $send_message = true;
                }
            } else {
                $send_message = true;
            }
             
            
          
            if ($send_message) {
                $pending_messages = $this->db->query("SELECT * FROM `" . DB_PREFIX . "modulus_send_later` WHERE is_sent = 0")->rows;
                foreach ($pending_messages as $message) {
                    $PhoneNumber = $message['phone_number'];
                    $Message = $message['message'];
                    $order_id = $message['order_id'];
                    $cus_id = $message['cus_id'];
                    $order_status_id = $message['order_status_log'];
    
           
                    require_once(DIR_SYSTEM . 'library/modulus/modulusSend.php');
                    $smsSender = new modulusSend();
                    $smsSender->setUrl($this->config->get('modulus_settings_api_url'));
                    $smsSender->setSenderId($this->config->get('modulus_settings_senderid'));
                    $smsSender->setApiToken($this->config->get('modulus_settings_api_token'));
                    $smsSender->setChannel($this->config->get('modulus_settings_channel'));
                    $smsSender->addPhone($PhoneNumber);
                    $smsSender->addSmsMessage($Message);
                    list($httpCode, $response) = $smsSender->send();
                    
                    
                    if ($httpCode == 200) {

                        $responseObject = json_decode($response);
                        $messageId = $responseObject->messages[0]->messageId;
                        $callbackcode = $responseObject->messages[0]->status->code;
                        $callbackmessage = $responseObject->messages[0]->status->message;
                        if ($order_id > 0) {
                        $this->model_extension_module_modulus->updateLogs($order_id, $PhoneNumber, $Message,$order_status_id, $messageId, $callbackcode, $callbackmessage);
                        } else if ($cus_id > 0) {
                            $this->model_extension_module_modulus->updateLogscus($cus_id, $PhoneNumber, $Message, $order_status_id, $messageId, $callbackcode, $callbackmessage);
                        }
                        $json['success'] = $callbackmessage;
                    } else {
                        $json['error'] = 'SMS could not be sent. Response code: ' . $response;
                    }
        
                    $this->response->addHeader('Content-Type: application/json');
                    $this->response->setOutput(json_encode($json));
                        $this->db->query("UPDATE `" . DB_PREFIX . "modulus_send_later` SET is_sent = 1 WHERE id = '" . (int)$message['id'] . "'");
                    
                }
    
          
                $this->session->data['success'] = 'Pending messages sent successfully.';
            }
        
    }
    
    
   
    
    public function tempstatuses()
    {
        $this->load->language('extension/module/modulus');

        $this->document->setTitle(strip_tags($this->language->get('heading_title')));

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->load->model('setting/setting');

            $this->model_setting_setting->editSetting('modulus_tempstatuses', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_tempstatus_saved');

            $this->response->redirect($this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=tempstatuses', true));
        }

        $this->getList();
    }

    public function save_template()
    {
        $this->load->language('extension/module/modulus');

        $this->document->setTitle(strip_tags($this->language->get('heading_title')));

        $this->load->model('extension/module/modulus');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_extension_module_modulus->saveTemplates($this->request->get['template_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=templates', true));
        }

        $this->getList();
    }

    public function delete_template()
    {
        $this->load->language('extension/module/modulus');

        $this->document->setTitle(strip_tags($this->language->get('heading_title')));

        $this->load->model('extension/module/modulus');

        if (($this->request->server['REQUEST_METHOD'] == 'GET') && $this->validateForm()) {

            $this->model_extension_module_modulus->deleteTemplates($this->request->get['template_id']);

            $this->session->data['success'] = $this->language->get('text_success_delete');

            $this->response->redirect($this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=templates', true));
        }

        $this->getList();
    }

    public function active_template()
    {
        $this->load->language('extension/module/modulus');

        $this->document->setTitle(strip_tags($this->language->get('heading_title')));

        $this->load->model('extension/module/modulus');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_extension_module_modulus->activeTemplates($this->request->get['template_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=templates', true));
        }

        $this->getList();
    }


    public function update_order_status() {
        $json = array();
      
        if (isset($this->request->post['order_status_id']) && isset($this->request->post['sent_sms']) && isset($this->request->post['template_id'])) {
        
            $order_status_id = $this->request->post['order_status_id'];
            $sms_sent = $this->request->post['sent_sms'];
            $language_id = $this->request->post['language_id'];
            $template_id = $this->request->post['template_id'];
    
            $this->load->model('extension/module/modulus');

            $existing = $this->model_extension_module_modulus->getTemplateStatusByOrderStatusId($order_status_id);

            if ($existing) {
                $this->model_extension_module_modulus->updateTemplateStatus($order_status_id, $sms_sent, $template_id);
                $json['success'] = 'Status updated successfully.';
            } else {
                $this->model_extension_module_modulus->addTemplateStatus($order_status_id, $sms_sent, $template_id,$language_id);
                $json['success'] = 'Status created successfully.';
            }
        } else {
            $json['error'] = 'Missing data.';
        }
     
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

 


    public function sendTestSms() {
     
        $this->load->library('modulus/modulussend');
        
        $modulusSend = new modulusSend();
        
        $modulusSend->setmodulusLogin($this->config->get('modulus_login'));
        
        $modulusSend->addPhone($this->request->post['phone']);
        $modulusSend->addSmsMessage($this->request->post['message']);
        
        $result = $modulusSend->send();
        
        if ($result[0] == 200) {
            $this->response->setOutput(json_encode([
                'success' => 'SMS sent successfully!',
                'result'  => $result[1]
            ]));
        } else {
            $this->response->setOutput(json_encode([
                'error' => 'Failed to send SMS.',
                'result' => $result[1]
            ]));
        }
    }


    public function getTemplateText() {
        $json = array();
    
        if (isset($this->request->get['template_id'])) {
            $template_id = $this->request->get['template_id'];
            $this->load->model('extension/module/modulus');
    
            $template_text = $this->model_extension_module_modulus->getTemplateTextById($template_id);

            if ($template_text) {
                $json['success'] = true;
                $json['text'] = $template_text;
            } else {
                $json['success'] = false;
            }
        } else {
            $json['success'] = false;
        }
    
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }


    protected function getList()
    {
        $tab = isset($this->request->get['tab']) ? $this->request->get['tab'] : 'settings';

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data = [
            'sort'     => $sort,
            'order'    => $order,
            'page'     => $page,
            'start'    => $this->config->get('config_limit_admin') * ($page - 1),
            'limit'    => $this->config->get('config_limit_admin'),
            'page_tab' => $tab,
        ];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], true),
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_module'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true),
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'], true),
        ];

        $data['heading_title'] = $this->language->get('heading_title');

        $data['tab_settings'] = $this->language->get('tab_settings');
        $data['tab_testsms'] = $this->language->get('tab_testsms');
        $data['tab_tempstatuses'] = $this->language->get('tab_tempstatuses');
        $data['tab_templates'] = $this->language->get('tab_templates');
        

        $data['history_action'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=history', true);
        $data['testsms_action'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=testsms', true);
      
        $data['tempstatuses_action'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=tempstatuses', true);
        $data['testsms_action_save'] = $this->url->link('extension/module/modulus/testsms', 'user_token=' . $this->session->data['user_token'], true);
      
        $data['settings_action'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=settings', true);
        $data['settings_action_save'] = $this->url->link('extension/module/modulus/settings', 'user_token=' . $this->session->data['user_token'], true);
        $data['templates_action'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=templates', true);
        $data['templates_action_edit'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=edit-templates', true);
        $data['templates_action_edit_save'] = $this->url->link('extension/module/modulus/save_template', 'user_token=' . $this->session->data['user_token'] . '&template_id=' . (!empty($this->request->get['template_id']) ? $this->request->get['template_id'] : '0'), true);
        $data['cancel'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['entry_sending_channel'] = $this->language->get('entry_sending_channel');
        $data['text_senderid'] = $this->language->get('text_senderid');
        $data['entry_modulus_login'] = $this->language->get('entry_modulus_login');
        $data['text_modulus_login'] = $this->language->get('text_modulus_login');
        $data['text_create_template'] = $this->language->get('text_create_template');
        $data['text_event'] = $this->language->get('text_event');
        $data['text_category'] = $this->language->get('text_category');
        $data['text_recipient'] = $this->language->get('text_recipient');
        $data['text_templatetitle'] = $this->language->get('text_templatetitle');
        $data['text_templatemessage'] = $this->language->get('text_templatemessage');
        $data['text_status'] = $this->language->get('text_status');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['column_active'] = $this->language->get('column_active');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_title'] = $this->language->get('column_title');
        $data['column_action'] = $this->language->get('column_action');
        $data['column_date'] = $this->language->get('column_date');
        $data['column_product_id'] = $this->language->get('column_product_id');
        $data['column_product_name'] = $this->language->get('column_product_name');
        $data['column_channel'] = $this->language->get('column_channel');
        $data['column_phone'] = $this->language->get('column_phone');
        $data['text_edit_template'] = $this->language->get('text_edit_template');
        $data['text_delete_template'] = $this->language->get('text_delete_template');
        $data['column_language'] = $this->language->get('column_language');
        $data['button_cancel'] = $this->language->get('button_cancel');
        $data['button_save'] = $this->language->get('button_save');

        $data['user_token'] = $this->session->data['user_token'];

        $data['modulus_settings_modulus_login'] = $this->config->get('modulus_settings_modulus_login');
        $data['modulus_settings_senderid'] = $this->config->get('modulus_settings_senderid');
        $data['modulus_settings_backinstock'] = $this->config->get('modulus_settings_backinstock');
        $data['modulus_settings_timelimit'] = $this->config->get('modulus_settings_timelimit');
        $data['modulus_settings_backinstock_message'] = $this->config->get('modulus_settings_backinstock_message');
        $data['modulus_settings_api_url'] = $this->config->get('modulus_settings_api_url');
        $data['modulus_settings_api_token'] = $this->config->get('modulus_settings_api_token');
        $data['modulus_settings_channel'] = $this->config->get('modulus_settings_channel');
        $data['modulus_settings_status'] = $this->config->get('modulus_settings_status');

        $data['modulus_settings_monday_from'] = $this->config->get('modulus_settings_monday_from');
        $data['modulus_settings_monday_to'] = $this->config->get('modulus_settings_monday_to');
        $data['modulus_settings_tuesday_from'] = $this->config->get('modulus_settings_tuesday_from');
        $data['modulus_settings_tuesday_to'] = $this->config->get('modulus_settings_tuesday_to');
        $data['modulus_settings_wednesday_from'] = $this->config->get('modulus_settings_wednesday_from');
        $data['modulus_settings_wednesday_to'] = $this->config->get('modulus_settings_wednesday_to');
        $data['modulus_settings_thursday_from'] = $this->config->get('modulus_settings_thursday_from');
        $data['modulus_settings_thursday_to'] = $this->config->get('modulus_settings_thursday_to');
        $data['modulus_settings_friday_from'] = $this->config->get('modulus_settings_friday_from');
        $data['modulus_settings_friday_to'] = $this->config->get('modulus_settings_friday_to');
        $data['modulus_settings_saturday_from'] = $this->config->get('modulus_settings_saturday_from');
        $data['modulus_settings_saturday_to'] = $this->config->get('modulus_settings_saturday_to');
        $data['modulus_settings_sunday_from'] = $this->config->get('modulus_settings_sunday_from');
        $data['modulus_settings_sunday_to'] = $this->config->get('modulus_settings_sunday_to');

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_extension_module_modulus->getOpStatuses();

        $data['active_templates'] = $this->model_extension_module_modulus->getActiveTemplates();

        $this->load->model('localisation/return_status');

        $data['return_statuses'] = $this->model_localisation_return_status->getReturnStatuses();

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();

        $data['categories'] = $this->model_extension_module_modulus->getCategories();

        if (isset($this->request->post['store_id'])) {
            $data['store_id'] = $this->request->post['store_id'];
        } else {
            $data['store_id'] = '';
        }

        $this->load->model('setting/store');

        $data['stores'] = $this->model_setting_store->getStores();

      

        $data['this_template'] = [];

        if ($tab == 'templates' || $tab == 'edit-templates') {
            $templates = $this->model_extension_module_modulus->getTemplates();

            foreach ($templates as $cat_id => $temp) {
                foreach ($temp as $id => $template) {
                    $templates[$cat_id][$id]['link'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&tab=edit-templates&template_id=' . $template['id'], true);
                    $templates[$cat_id][$id]['link_delete'] = $this->url->link('extension/module/modulus/delete_template', 'user_token=' . $this->session->data['user_token'] . '&template_id=' . $template['id'], true);
                    $templates[$cat_id][$id]['link_active'] = $this->url->link('extension/module/modulus/active_template', 'user_token=' . $this->session->data['user_token'] . '&template_id=' . $template['id'], true);

                    if (isset($this->request->get['template_id']) && $this->request->get['template_id'] == $template['id']) {
                        $data['this_template'] = $template;
                    }

                }
            }

            $data['templates'] = $templates;
        }

        $total = 0;
        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }


        if ($tab == 'history') {
            /*
            $historys = $this->model_extension_module_modulus->getHistory($data['limit'], $data['start']);
            if (!empty($historys) && is_array($historys))
                foreach ($historys as $key => $value) {
                    $historys[$key]['created_at'] = (new DateTime($value['created_at']))->format('d.m.Y H:i');
                    $badge_text = $value['type'] == 'danger' || $value['type'] == 'warning' ? $this->language->get('text_status_warning') : $this->language->get('text_status_success');
                    if (isset($value['response']['delivered']) && $value['response']['delivered']) {
                        $badge_text = $this->language->get('text_status_delivered');
                    }
                    $historys[$key]['badge_text'] = $badge_text;
                }
            $data['historys'] = $this->model_extension_module_modulus->getHistory($data['limit'], $data['start']);
           $total = $this->model_extension_module_modulus->getHistoryTotal();
           */

           $data['historys'] = $this->model_extension_module_modulus->getBackInstockLogs();
        }

        $pagination = new Pagination();

        $pagination->total = $total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->text = $this->language->get('text_pagination');
        $pagination->url = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}&tab=' . $tab, true);

        $data['pagination'] = $pagination->render();


        $data['results'] = sprintf($this->language->get('text_pagination'), ($total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total - $this->config->get('config_limit_admin'))) ? $total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total, ceil($total / $this->config->get('config_limit_admin')));


        $data['sort'] = $sort;
        $data['order'] = $order;

        if ($order == 'ASC') {
            $order = 'DESC';
        } else {
            $order = 'ASC';
        }

        $url = '';

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&sort=name&order=' . $order . $url, true);
        $data['sort_type'] = $this->url->link('extension/module/modulus', 'user_token=' . $this->session->data['user_token'] . '&sort=type&order=' . $order . $url, true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/modulus_list', $data));
    }

    protected function validateForm()
    {
        if (!$this->user->hasPermission('modify', 'extension/module/modulus')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function install()
    {
        if (!$this->user->hasPermission('modify', 'extension/extension/module')) {
            return;
        }
        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "modulus_requests` (
		  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
		  `channel` varchar(255) NOT NULL,
		  `phone` varchar(255) NOT NULL,
		  `message` varchar(1000) NOT NULL,
		  `message_id` varchar(255) DEFAULT NULL,
		  `status` int(11) DEFAULT NULL,
		  `error` varchar(255) DEFAULT NULL,
		  `type` varchar(255) DEFAULT NULL,
		  `created_at` timestamp NULL DEFAULT NULL,
		  `updated_at` timestamp NULL DEFAULT NULL,
		  `store_id` int(11) NOT NULL,
		  PRIMARY KEY (`id`)
		) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;");

        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "modulus_responses` (
		  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
		  `message_id` varchar(255) NOT NULL,
		  `channel` varchar(255) NOT NULL,
		  `external_id` varchar(255) DEFAULT NULL,
		  `status` int(11) DEFAULT NULL,
		  `type` varchar(255) DEFAULT NULL,
		  `created_at` timestamp NULL DEFAULT NULL,
		  `updated_at` timestamp NULL DEFAULT NULL,
		   PRIMARY KEY (`id`)
		) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;");

        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "modulus_history` (
            `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
            `order_id` int(11) DEFAULT NULL,
            `cus_id` int(11) DEFAULT NULL,
            `phone_number` varchar(255) NOT NULL,
            `message` varchar(255) DEFAULT NULL,
            `status` int(11) DEFAULT NULL,
            `order_status_log` varchar(255) DEFAULT NULL,
            `message_id` varchar(255) DEFAULT NULL,
            `callback_code` int(11) DEFAULT NULL,
            `callback_message` varchar(255) DEFAULT NULL,
            `created_at` timestamp NULL DEFAULT NULL,
             PRIMARY KEY (`id`)
          ) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;");

          $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "modulus_send_later` (
            `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
            `phone_number` varchar(255) NOT NULL,
            `message` varchar(255) DEFAULT NULL,
            `is_sent` tinyint(1) NOT NULL DEFAULT 0,
            `order_id` int(11) DEFAULT NULL,
            `cus_id` int(11) DEFAULT NULL,
            `order_status_log` varchar(255) DEFAULT NULL,
            `created_at` timestamp NULL DEFAULT NULL,
            PRIMARY KEY (`id`)
        ) DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");


        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "modulus_templates` (
		  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
		  `store_id` int(11) NOT NULL,
		  `group` varchar(191) NOT NULL,
		  `action` varchar(191) NOT NULL,
		  `number` varchar(191) NOT NULL,
		  `message` text NOT NULL,
		  `active` tinyint(1) NOT NULL,
		  `language` int(11) NOT NULL,
		   PRIMARY KEY (`id`)
		) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;");

        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "modulus_back_in_stock` (
            `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            `phone` varchar(255) NOT NULL,
            `product_id` int(11) NOT NULL,
            `notify_id` int(11) NOT NULL,
            PRIMARY KEY (`id`)
          ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");


        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "modulus_orders_board` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `order_status_id` int(11) NOT NULL,
            `send_sms` int(11) NOT NULL,
            `template_id` int(11) NOT NULL,
            `language_id` int(11) NOT NULL,
            PRIMARY KEY (`id`)
        ) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;");


          $this->load->model('setting/setting');
          $this->model_setting_setting->editSetting('module_modulus', ['module_modulus_status' => 1]);

//
//        $this->load->model('setting/store');
//        $stores = $this->model_setting_store->getStores();
//        $stores[] = ['store_id' => 0];


        $this->load->model('setting/event');

        $this->model_setting_event->deleteEvent('module_modulus');

        $this->model_setting_event->addEvent('module_modulus', 'catalog/model/checkout/order/addOrderHistory/after', 'extension/module/modulus/eventChangeOrder');
        $this->model_setting_event->addEvent('module_modulus', 'admin/model/catalog/product/editProduct/after', 'extension/module/modulus/eventProductUpdate');
       // $this->model_setting_event->addEvent('module_modulus', 'admin/model/sale/return/addReturnHistory/after', 'extension/module/modulus/eventChangeReturn');
       // $this->model_setting_event->addEvent('module_modulus', 'admin/model/sale/return/addReturn/after', 'extension/module/modulus/eventChangeReturn');
    }

    public function uninstall()
    {
        if (!$this->user->hasPermission('modify', 'extension/extension/module')) {
            return;
        }

        $this->load->model('setting/event');

        $this->model_setting_event->deleteEventByCode('module_modulus');

        $this->load->model('setting/setting');
        $this->model_setting_setting->deleteSetting('module_modulus');
        
    }


    public function eventProductUpdate($route, $args, $output) {
     
        $product_id = $args[0];
        
   
        $this->load->model('catalog/product');
        $this->load->model('extension/module/modulus');
        $product_info = $this->model_catalog_product->getProduct($product_id);
        $this->load->model('setting/setting');
        $backinstock_message = $this->config->get('modulus_settings_backinstock_message');
        $timelimit =  $this->config->get('modulus_settings_timelimit');
        $hourRanges = array(
            'Monday' => array('from' => $this->config->get('modulus_settings_monday_from'), 'to' => $this->config->get('modulus_settings_monday_to')),
            'Tuesday' => array('from' => $this->config->get('modulus_settings_tuesday_from'), 'to' => $this->config->get('modulus_settings_tuesday_to')),
            'Wednesday' => array('from' => $this->config->get('modulus_settings_wednesday_from'), 'to' => $this->config->get('modulus_settings_wednesday_to')),
            'Thursday' => array('from' => $this->config->get('modulus_settings_thursday_from'), 'to' => $this->config->get('modulus_settings_thursday_to')),
            'Friday' => array('from' => $this->config->get('modulus_settings_friday_from'), 'to' => $this->config->get('modulus_settings_friday_to')),
            'Saturday' => array('from' => $this->config->get('modulus_settings_saturday_from'), 'to' => $this->config->get('modulus_settings_saturday_to')),
            'Sunday' => array('from' => $this->config->get('modulus_settings_sunday_from'), 'to' => $this->config->get('modulus_settings_sunday_to'))
        );

        $link = $this->url->link('product/product', 'product_id=' . $product_info['product_id'] . $url);

        $catalog_base_url = HTTP_CATALOG;
        $link = $catalog_base_url . 'index.php?route=product/product&product_id=' . $product_info['product_id'];

        $backinstock_message = str_replace("{product_name}", $product_info['name'], $backinstock_message);
        $backinstock_message = str_replace("{product_url}", $link, $backinstock_message);
       
    
        if ($product_info && $product_info['quantity'] > 0) {

            $send_message = true;
            if ($timelimit == 1) {
                date_default_timezone_set('Europe/Athens');
                $currentDay = date('l');
                $currentHour = date('H:i');
                $hasHourRanges = false;
    
                  foreach ($hourRanges as $day => $hourRange) {
                    if ($hourRange['from'] != '' && $hourRange['to'] != '') {
                      
                        $hasHourRanges = true;
    
                        if ($day == $currentDay) {
                            $fromTime = strtotime($hourRange['from']);
                            $toTime = strtotime($hourRange['to']);
                            $currentTime = strtotime($currentHour);

                            if ($currentTime >= $fromTime && $currentTime <= $toTime) {
                              
                                $send_message = true;
                                break;
                            } else {
                            
                                $send_message = false;
                            }
                        }
                    }
                }

                if (!$hasHourRanges) {
                    $send_message = true;
                }
            } else {
                $send_message = true;
            }

    
            if ($send_message == true) {

            $phonesToNotify = $this->model_extension_module_modulus->getPhonesForBackInStockNotify($product_id);

            if (!empty($phonesToNotify)) {
                
                require_once(DIR_SYSTEM . 'library/modulus/modulusSend.php');
                $smsSender = new modulusSend();
                $smsSender->setUrl($this->config->get('modulus_settings_api_url'));
                $smsSender->setSenderId($this->config->get('modulus_settings_senderid'));
                $smsSender->setApiToken($this->config->get('modulus_settings_api_token'));
                $smsSender->setChannel($this->config->get('modulus_settings_channel'));
                //$product_info['name']
    
               
                foreach ($phonesToNotify as $notify) {

                    $customer_phone = $notify['phone'];

                    if ($customer_phone && substr($customer_phone, 0, 3) !== '+30' || substr($customer_phone, 0, 4) !== '0030') {
                        
                        if (substr($customer_phone, 0, 1) === '0') {
                            $customer_phone = substr($customer_phone, 1);
                        }
                        $customer_phone = '+30' . $customer_phone;
                    }
                    
                    $smsSender->addPhone( $customer_phone);
                    $smsSender->addSmsMessage($backinstock_message);
    
                   
                    list($httpCode, $response) = $smsSender->send();

                    $this->log->write(  $backinstock_message);

                  // $this->model_extension_module_modulus->updateLogs($order_id, $PhoneNumber, $Message, $order_status_id);
                    
                    $this->model_extension_module_modulus->updateNotifyStatus($notify['id']);
                }
                
            }

        }else{

            $phonesToNotify = $this->model_extension_module_modulus->getPhonesForBackInStockNotify($product_id);
            foreach ($phonesToNotify as $notify) {

                $customer_phone = $notify['phone'];

                if ($customer_phone && substr($customer_phone, 0, 3) !== '+30' || substr($customer_phone, 0, 4) !== '0030') {
             
                    if (substr($customer_phone, 0, 1) === '0') {
                        $customer_phone = substr($customer_phone, 1);
                    }
                    $customer_phone = '+30' . $customer_phone;
                }
                
            
            $order_id = 0;
            $order_info = 0;
            $cus_id = 0;
            $order_status_id = 0;                
            $this->model_extension_module_modulus->saveForLaterSendingProd($customer_phone, $backinstock_message, $order_id, $order_status_id);
            $json['success'] = 'Message saved for later sending.';
           
            $this->model_extension_module_modulus->updateNotifyStatus($notify['id']);
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode($json));

        }
            
        }
    }
}

    public function eventChangeReturn($hook, $args, $output)
    {
        if ($this->config->get('modulus_settings_status')) {
            $this->load->model('sale/return');
            $this->load->model('extension/module/modulus');
            $this->load->model('sale/order');
            $this->load->model('setting/setting');
    

            $return_id = !empty($this->request->get['return_id']) ? $this->request->get['return_id'] : (!empty($args[0]) && !is_array($args[0]) ? $args[0] : 0);
            $return_status_id = !empty($this->request->post['return_status_id']) ? $this->request->post['return_status_id'] : (!empty($args[1]) ? $args[1] : 0);
            $comment = !empty($this->request->post['comment']) ? $this->request->post['comment'] : (!empty($args[2]) ? $args[2] : '');
            $notify = !empty($this->request->post['notify']) ? $this->request->post['notify'] : (!empty($args[3]) ? $args[3] : '');

            if (!empty($return_id))
                $return_order_info = $this->model_sale_return->getReturn($return_id);
            else if (!empty($args[0]) && is_array($args[0]))
                $return_order_info = $args[0];

            if (!empty($return_order_info)) {

                $order_id = !empty($return_order_info['order_id']) ? $return_order_info['order_id'] : '';

                $order_info = $this->model_sale_order->getOrder($order_id);

                $store_id = 0;

                if (!empty($order_info)) {

                    $store_id = $order_info['store_id'];

                    $language_id = $order_info['language_id'];

                    $templates = $this->model_extension_module_modulus->getTemplateByAction($store_id, 'return_status-' . $return_status_id, $language_id);

                } else {
                    $templates = $this->model_extension_module_modulus->getTemplateByAction(false, 'return_status-' . $return_status_id, false);
                }


                if (!empty($templates)) {
                    foreach ($templates as $template) {
                        $phone = $template['number'];
                        $message = $template['message'];
                        $phone = $this->model_extension_module_modulus->parseShortcodeOrder($phone, $order_info, $return_order_info);
                        $message = $this->model_extension_module_modulus->parseShortcodeOrder($message, $order_info, $return_order_info);
                        if (!empty($phone) && !empty($message))
                            $this->model_extension_module_modulus->send($phone, $message, $store_id);
                    }
                }

            
        }

                }

            }

 
    public function customerList() {
    
        $this->load->model('customer/customer');
        $customer_info = $this->model_customer_customer->getCustomers(); 
        $data['customer_info'] = $customer_info;
        
        
        $this->response->setOutput($this->load->view('extension/module/modulus_list', $data));
    
    }

}
