<?php

class ModelExtensionModulemodulus extends Model
{
    /**
     * @return false|mixed|void
     */
    public function getTemplates()
    {
        $this->load->model('setting/store');

        $templates = [];
        $categories = $this->getCategories();
        if (!empty($categories))
            foreach ($categories as $category)
                $templates[$category['id']] = [];

        $templates_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_templates WHERE 1");

        if (!empty($templates_query->rows)) {
            foreach ($templates_query->rows as $row) {
                if ($row['store_id']) {
                    $store = $this->model_setting_store->getStore($row['store_id']);
                    $store = $store['name'];
                } else {
                    $store = $this->language->get('text_default');
                }

                $row['store'] = $store;

                $templates[$row['group']][] = $row;
            }
        }

   
        return $templates;


    }

    public function saveForLaterSending($PhoneNumber, $Message, $order_id, $order_status_id) {
        $this->db->query("INSERT INTO `" . DB_PREFIX . "modulus_send_later` (phone_number, message, order_id, cus_id,order_status_log) VALUES ('" . $this->db->escape($PhoneNumber) . "', '" . $this->db->escape($Message) . "','" . $this->db->escape($order_id) . "','" . $this->db->escape($cus_id) . "','" . $this->db->escape($order_status_id) . "')");
    }

    public function saveForLaterSendingCus($PhoneNumber, $Message, $cus_id) {
        $this->db->query("INSERT INTO `" . DB_PREFIX . "modulus_send_later` (phone_number, message, order_id, cus_id,order_status_log) VALUES ('" . $this->db->escape($PhoneNumber) . "', '" . $this->db->escape($Message) . "','" . $this->db->escape($order_id) . "','" . $this->db->escape($cus_id) . "','" . $this->db->escape($order_status_id) . "')");
    }

    public function saveForLaterSendingProd($customer_phone, $backinstock_message, $order_id) {
        $this->db->query("INSERT INTO `" . DB_PREFIX . "modulus_send_later` (phone_number, message, order_id, cus_id,order_status_log) VALUES ('" . $this->db->escape($customer_phone) . "', '" . $this->db->escape($backinstock_message) . "','" . $this->db->escape($order_id) . "','" . $this->db->escape($cus_id) . "','" . $this->db->escape($order_status_id) . "')");
    }

  

    public function getActiveTemplates()
    {
        $this->load->model('setting/store');

        $templates = [];
      
        $templates_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_templates WHERE active = 1");

        if (!empty($templates_query->rows)) {
            foreach ($templates_query->rows as $row) {
                $templates[] = array('id'=>$row['id'] , 'title' => $row['number'], 'language' => $row['language']);
            }
        }
   
        return $templates;


    }


    
    public function getTemplateTextById($template_id)
    {
        $this->load->model('setting/store');

        $template_text = '';
      
        $templates_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_templates WHERE active = 1 and id = ".$template_id);

        if (!empty($templates_query->rows)) {
            foreach ($templates_query->rows as $row) {
                $template_text =  $row['message'];
            }
        }
   
        return $template_text;

    }


    public function getOpStatuses($data = array()) {
	
			$sql = "SELECT a.*, b.send_sms, b.template_id FROM " . DB_PREFIX . "order_status a LEFT JOIN " . DB_PREFIX . "modulus_orders_board b on a.order_status_id = b.order_status_id WHERE a.language_id = '" . (int)$this->config->get('config_language_id') . "'";
          
			$sql .= " ORDER BY a.name";

			$query = $this->db->query($sql);

			return $query->rows;
            
	}


    public function getTemplateStatusByOrderStatusId($order_status_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_orders_board WHERE order_status_id = '" . (int)$order_status_id . "'");
        return $query->row;
    }


    

    public function sendSMS($order_status_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_orders_board WHERE order_status_id = '" . (int)$order_status_id . "' and send_sms = 1");

        $sms_settings = [];

        if($query->row){
            $template = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_templates WHERE id = '" . (int)$query->row['template_id'] . "'");

            $sms_settings[] = array(
                'enabled'=>'true',
                'template_text'=> $template->row['message']
            );

            return $sms_settings;

        }else{
            return false;
        }
       
    }
    
    public function updateTemplateStatus($order_status_id, $sms_sent, $template_id) {
        if($sms_sent > 0){

            $this->db->query("UPDATE " . DB_PREFIX . "modulus_orders_board SET send_sms = '" . $this->db->escape($sms_sent) . "' WHERE order_status_id = '" . (int)$order_status_id . "'");

        }else{
            $this->db->query("UPDATE " . DB_PREFIX . "modulus_orders_board SET template_id = '" . (int)$template_id . "' WHERE order_status_id = '" . (int)$order_status_id . "'");
        }    
     
    }
    
    public function addTemplateStatus($order_status_id, $sms_sent, $template_id,$language_id) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "modulus_orders_board SET order_status_id = '" . (int)$order_status_id . "', send_sms = '" . $this->db->escape($sms_sent) . "', template_id = '" . (int)$template_id . "' , language_id = language_id = '" . (int)$language_id . "'");
    }
    

    public function getCategories()
    {
        return [
            ['id' => 'order', 'name' => $this->language->get('cat_order'),],
          /*  ['id' => 'payment', 'name' => $this->language->get('cat_payment'),],
            ['id' => 'delivery', 'name' => $this->language->get('cat_delivery'),],
            ['id' => 'admin', 'name' => $this->language->get('cat_admin'),],
            ['id' => 'miscellaneous', 'name' => $this->language->get('cat_miscellaneous'),], */
        ];
    }

    public function saveTemplates($id, $data)
    {
        if (empty($id)) {
            if (!empty($data['number']) && is_array($data['number']))
                foreach ($data['number'] as $lang => $number)
                    if (!empty($number) && !empty($data['message'][$lang]))
                        $this->db->query("INSERT INTO " . DB_PREFIX . "modulus_templates SET `store_id` = '" . (int)$data['store_id'] . "', `group` = '" . $this->db->escape($data['group']) . "', `action` = '" . $this->db->escape($data['action']) . "', `number` = '" . $this->db->escape($number) . "', `message` = '" . $this->db->escape($data['message'][$lang]) . "', `active` = true, `language` = '" . (int)$this->db->escape($lang) . "'");
        } else {
            if (!empty($data['number']) && !empty($data['message']))
                $this->db->query("UPDATE " . DB_PREFIX . "modulus_templates SET `store_id` = '" . (int)$data['store_id'] . "', `group` = '" . $this->db->escape($data['group']) . "', `action` = '" . $this->db->escape($data['action']) . "', `number` = '" . $this->db->escape($data['number']) . "', `message` = '" . $this->db->escape($data['message']) . "' WHERE `id` = '" . $this->db->escape($id) . "';");
        }
    }

    public function activeTemplates($id, $data)
    {
        if (!empty($id)) {
            $this->db->query("UPDATE " . DB_PREFIX . "modulus_templates SET `active` = " . ($data['active'] == 'true' ? 'true' : 'false') . " WHERE `id` = '" . $this->db->escape($id) . "';");
        }
    }

    public function deleteTemplates($id)
    {
        if (!empty($id)) {
            $this->db->query("DELETE FROM " . DB_PREFIX . "modulus_templates  WHERE `id` = '" . $this->db->escape($id) . "';");
        }
    }

    public function getHistory($limit, $offset)
    {
//        $dt_start = new DateTime(!empty($this->request->get['dt-start']) ? $this->request->get['dt-start'] : date("d-m-Y", strtotime("-6 day")));
//        $dt_end = new DateTime(!empty($this->request->get['dt-end']) ? $this->request->get['dt-end'] : date("d-m-Y"));
//        $modulus_requests = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_requests WHERE `created_at` BETWEEN '" . $dt_start->format('Y-m-d 00:00:00') . "' AND '" . $dt_end->format('Y-m-d 23:59:59') . "' ORDER BY `id` DESC LIMIT " . $limit . " OFFSET " . $offset);
        $modulus_requests = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_requests WHERE 1 ORDER BY `id` DESC LIMIT " . $limit . " OFFSET " . $offset);
        $modulus_requests = $modulus_requests->rows;
        if ($modulus_requests) {

            $ids = array_diff(array_unique(array_column($modulus_requests, 'message_id')), ['']);
            $modulus_response = $ids ? $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_responses WHERE `message_id` IN ('" . implode('\', \'', $ids) . "')") : [];

            $modulus_response_arr = [];
            if (!empty($modulus_response->rows))
                foreach ($modulus_response->rows as $response) {
                    $response['error'] = $this->getHookMessage($response['status']);
                    $modulus_response_arr[$response['message_id']]['array'][] = $response;
                    if ($response['status'] == 70)
                        $modulus_response_arr[$response->message_id]['delivered'] = true;
                }

            foreach ($modulus_requests as $key => $request)
                if (!empty($request['message_id']))
                    $modulus_requests[$key]['response'] = !empty($modulus_response_arr[$request['message_id']]) ? $modulus_response_arr[$request['message_id']] : [];

        }
        return $modulus_requests;
    }

    public function getHookMessage($status)
    {
        $this->load->language('extension/module/modulus');

        return $this->language->get('hook_status_' . $status);
    }

    public function getHistoryTotal()
    {
        $modulus_requests = $this->db->query("SELECT count(*) as count FROM " . DB_PREFIX . "modulus_requests WHERE 1");
        $modulus_requests = $modulus_requests->rows;
        return !empty($modulus_requests[0]['count']) ? $modulus_requests[0]['count'] : 0;
    }

    public function setHistory($http_code, $errors, $phone, $text, $sending_method, $store_id)
    {
        if (!empty($errors)) {
            foreach ($errors as $error) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "modulus_requests SET `channel` = '" . (!empty($sending_method) ? $sending_method : 'sms') . "', `phone` = '" . $this->db->escape(!empty($error['phone']) ? $error['phone'] : $phone) . "', `message` = '" . $this->db->escape($text) . "', `message_id` = '" . $this->db->escape(!empty($error['message_id']) ? $error['message_id'] : '') . "', `status` = '" . $this->db->escape($http_code) . "', `error` = '" . $this->db->escape($error['text']) . "', `type` = '" . $this->db->escape($error['type']) . "', `created_at` = '" . date('Y-m-d H:i:s') . "', `updated_at` = '" . date('Y-m-d H:i:s') . "', `store_id` = '" . (int)$this->db->escape($store_id) . "'");
            }
        } else {
            $this->db->query("INSERT INTO " . DB_PREFIX . "modulus_requests SET `channel` = '" . (!empty($sending_method) ? $sending_method : 'sms') . "', `phone` = '" . $this->db->escape($phone) . "', `message` = '" . $this->db->escape($text) . "', `message_id` = '" . $this->db->escape('') . "', `status` = '" . $this->db->escape($http_code) . "', `error` = '" . $this->db->escape('') . "', `type` = '" . $this->db->escape('') . "', `created_at` = '" . date('Y-m-d H:i:s') . "', `updated_at` = '" . date('Y-m-d H:i:s') . "', `store_id` = '" . (int)$this->db->escape($store_id) . "'");
        }
    }

    public function send($phone, $text, $store_id)
    {
        if (!empty($text)) {
            require_once DIR_SYSTEM . '/library/modulus/modulusSend.php';
            $modulusSend = new modulusSend();
            $modulusSend->setOptionsCallback($this->url->link('extension/module/modulus/callback', '', true));
            $modulusSend->addPhone($phone);

            $modulus_login = $this->config->get('modulus_settings_modulus_login');
            $from = $this->config->get('modulus_settings_senderid');
            $sending_method = $this->config->get('modulus_settings_channel');

            switch ($sending_method) {
                case 'viber':
                    $modulusSend->setFromViber($from);
                    $modulusSend->addViberMessage($text);
                    break;
                case 'viber2sms':
                    $modulusSend->setFromviber2sms($from);
                    $modulusSend->addviber2smsMessage($text);
                    break;
                default:
                    $modulusSend->setFromSms($from);
                    $modulusSend->addSmsMessage($text);
            }
            $modulusSend->setmodulusLogin($modulus_login);
            list($http_code,) = $modulusSend->send();
            $errors = $modulusSend->getErrors();

            $this->setHistory($http_code, $errors, $phone, $text, !empty($settings['sending_method']) ? $settings['sending_method'] : '', $store_id);
        }
    }

    public function testsend($phone, $text, $store_id)
    {
        if (!empty($text)) {
            require_once DIR_SYSTEM . '/library/modulus/modulusSend.php';
            $modulusSend = new modulusSend();
            $modulusSend->setOptionsCallback($this->url->link('extension/module/modulus/callback', '', true));
            $modulusSend->addPhone($phone);

            $modulus_login = $this->config->get('modulus_settings_modulus_login');
            $from = $this->config->get('modulus_settings_senderid');
            $sending_method = $this->config->get('modulus_settings_channel');

            switch ($sending_method) {
                case 'viber':
                    $modulusSend->setFromViber($from);
                    $modulusSend->addViberMessage($text);
                    break;
                case 'viber2sms':
                    $modulusSend->setFromviber2sms($from);
                    $modulusSend->addviber2smsMessage($text);
                    break;
                default:
                    $modulusSend->setFromSms($from);
                    $modulusSend->addSmsMessage($text);
            }
            $modulusSend->setmodulusLogin($modulus_login);
            list($http_code,) = $modulusSend->send();
            $errors = $modulusSend->getErrors();

            $this->setHistory($http_code, $errors, $phone, $text, !empty($settings['sending_method']) ? $settings['sending_method'] : '', $store_id);
        }
    }

    private function shortcodeParseAtts($text)
    {
        $atts = [];
        $pattern = '/([\w-]+)\s*=\s*"([^"]*)"(?:\s|$)|([\w-]+)\s*=\s*\'([^\']*)\'(?:\s|$)|([\w-]+)\s*=\s*([^\s\'"]+)(?:\s|$)|"([^"]*)"(?:\s|$)|\'([^\']*)\'(?:\s|$)|(\S+)(?:\s|$)/';
        $text = preg_replace("/[\x{00a0}\x{200b}]+/u", " ", $text);
        if (preg_match_all($pattern, $text, $match, PREG_SET_ORDER)) {
            foreach ($match as $m) {
                if (!empty($m[1]))
                    $atts[strtolower($m[1])] = stripcslashes($m[2]);
                else if (!empty($m[3]))
                    $atts[strtolower($m[3])] = stripcslashes($m[4]);
                else if (!empty($m[5]))
                    $atts[strtolower($m[5])] = stripcslashes($m[6]);
                else if (isset($m[7]) && strlen($m[7]))
                    $atts[] = stripcslashes($m[7]);
                else if (isset($m[8]) && strlen($m[8]))
                    $atts[] = stripcslashes($m[8]);
                else if (isset($m[9]))
                    $atts[] = stripcslashes($m[9]);
            }

            // Reject any unclosed HTML elements
            foreach ($atts as &$value) {
                if (false !== strpos($value, '<')) {
                    if (1 !== preg_match('/^[^<]*+(?:<[^>]*+>[^<]*+)*+$/', $value)) {
                        $value = '';
                    }
                }
            }
        } else {
            $atts = ltrim($text);
        }
        return $atts;
    }

    public function parseShortcodeOrder($text, $order, $return_order = false)
    {
        $shortcodes = [
            "order_id",
            "firstname",
            "lastname",
            "email",
            "telephone",
            "date_added",
            "payment_method",
            "shipping_method",
            "ip",
            "payment_address",
            "shipping_address",
            "products",
            "order_comment",
            "store_name",
            "store_url",
            "order_amount",
        ];
        foreach ($shortcodes as $shortcode) {
            if (preg_match_all('|\[' . $shortcode . '(.*)\]|isU', $text, $arr)) {
                if (!empty($arr[0])) {
                    foreach ($arr[0] as $key => $value) {
                        $attr = $this->shortcodeParseAtts(!empty($arr[1][$key]) ? $arr[1][$key] : '');
                        $before = !empty($attr['before']) ? $attr['before'] : '';
                        $after = !empty($attr['after']) ? $attr['after'] : '';

                        $replace_text = '';
                        switch ($shortcode) {
                            case "order_id":
                                if ($return_order)
                                    $replace_text = !empty($return_order['order_id']) ? $return_order['order_id'] : '';
                                else
                                    $replace_text = !empty($order['order_id']) ? $order['order_id'] : '';
                                break;
                            case "firstname":
                                if ($return_order)
                                    $replace_text = !empty($return_order['firstname']) ? $return_order['firstname'] : (!empty($order['firstname']) ? $order['firstname'] : (!empty($order['payment_firstname']) ? $order['payment_firstname'] : (!empty($order['shipping_firstname']) ? $order['shipping_firstname'] : '')));
                                else
                                    $replace_text = !empty($order['firstname']) ? $order['firstname'] : (!empty($order['payment_firstname']) ? $order['payment_firstname'] : (!empty($order['shipping_firstname']) ? $order['shipping_firstname'] : ''));
                                break;
                            case "lastname":
                                if ($return_order)
                                    $replace_text = !empty($return_order['lastname']) ? $return_order['lastname'] : (!empty($order['lastname']) ? $order['lastname'] : (!empty($order['payment_lastname']) ? $order['payment_lastname'] : (!empty($order['shipping_lastname']) ? $order['shipping_lastname'] : '')));
                                else
                                    $replace_text = !empty($order['lastname']) ? $order['lastname'] : (!empty($order['payment_lastname']) ? $order['payment_lastname'] : (!empty($order['shipping_lastname']) ? $order['shipping_lastname'] : ''));
                                break;
                            case "email":
                                if ($return_order)
                                    $replace_text = !empty($return_order['email']) ? $return_order['email'] : '';
                                else
                                    $replace_text = !empty($order['email']) ? $order['email'] : '';
                                break;
                            case "telephone":
                                if ($return_order)
                                    $replace_text = !empty($return_order['telephone']) ? $return_order['telephone'] : '';
                                else
                                    $replace_text = !empty($order['telephone']) ? $order['telephone'] : '';
                                break;
                            case "date_added":
                                if ($return_order)
                                    $replace_text = !empty($return_order['date_added']) ? $return_order['date_added'] : '';
                                else
                                    $replace_text = !empty($order['date_added']) ? $order['date_added'] : '';
                                break;
                            case "payment_method":
                                $replace_text = !empty($order['payment_method']) ? $order['payment_method'] : '';
                                break;
                            case "shipping_method":
                                $replace_text = !empty($order['shipping_method']) ? $order['shipping_method'] : '';
                                break;
                            case "ip":
                                $replace_text = !empty($order['forwarded_ip']) ? $order['forwarded_ip'] : '';
                                break;
                            case "payment_address":
                                $replace_text = !empty($order['payment_address_1']) ? $order['payment_address_1'] : '';
                                break;
                            case "shipping_address":
                                $replace_text = !empty($order['shipping_address_1']) ? $order['shipping_address_1'] : '';
                                break;
                            case "products":
                                $replace_text = '';

                                if ($return_order)
                                    $replace_text = !empty($return_order['product']) ? ($return_order['product'] . ' * ' . $return_order['quantity']) : '';
                                else {
                                    $order_product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int)(!empty($order['order_id']) ? $order['order_id'] : '') . "'");
                                    foreach ($order_product_query->rows as $product) {
                                        if (end($order_product_query->rows) == $product)
                                            $replace_text .= $product['name'] . ' * ' . $product['quantity'];
                                        else
                                            $replace_text .= $product['name'] . ' * ' . $product['quantity'] . ', ';
                                    }
                                }

                                break;
                            case "order_comment":
                                if ($return_order)
                                    $replace_text = !empty($return_order['comment']) ? $return_order['comment'] : '';
                                else
                                    $replace_text = !empty($order['comment']) ? $order['comment'] : '';
                                break;
                            case "store_name":
                                $replace_text = !empty($order['store_name']) ? $order['store_name'] : '';
                                break;
                            case "store_url":
                                $replace_text = !empty($order['store_url']) ? $order['store_url'] : '';
                                break;
                            case "order_amount":
                                if ($return_order)
                                    $replace_text = '';
                                else
                                    $replace_text = $this->currency->format($order['total'], $order['currency_code']);
                                break;
                        }
                        if (!empty($replace_text))
                            $replace_text = $before . $replace_text . $after;

                        $text = str_replace($value, $replace_text, $text);
                    }
                }
            }
        }
        return $text;
    }

    public function getTemplateByAction($store_id, $action, $language_id)
    {
        if ($store_id === false && $language_id === false) {
            $templates = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_templates WHERE `action` = '" . $this->db->escape($action) . "' AND `active` = true");
        } else
            $templates = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_templates WHERE `store_id` = '" . (int)$store_id . "' AND `language` = '" . (int)$language_id . "' AND `action` = '" . $this->db->escape($action) . "' AND `active` = true");
        return $templates->rows;
    }

    public function getPhonesForBackInStockNotify($product_id) {
        $query = $this->db->query("SELECT id, phone FROM `" . DB_PREFIX . "modulus_back_in_stock` WHERE product_id = '" . (int)$product_id . "' AND notify_id = 0");
        return $query->rows;
    }


    public function getBackInstockLogs() {
        $query = $this->db->query("SELECT a.phone, a.product_id,b.name FROM " . DB_PREFIX . "modulus_back_in_stock a INNER JOIN " . DB_PREFIX . "product_description b ON a.product_id = b.product_id WHERE a.notify_id = 1 and b.language_id = '" . (int)$this->config->get('config_language_id') . "'");
        return $query->rows;
    }


    public function getLogs($order_id) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "modulus_history` WHERE order_id = '" . (int)$order_id . "'");
        return $query->rows;
    }

    public function getLogscus($cus_id) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "modulus_history` WHERE cus_id = '" . (int)$cus_id . "'");
        return $query->rows;
    }
    
    public function updateLogs($order_id, $PhoneNumber, $Message, $order_status_id, $messageId, $callbackcode, $callbackmessage) {
        $order_id = $this->db->escape($order_id);
        $PhoneNumber = $this->db->escape($PhoneNumber);
        $Message = $this->db->escape($Message);
        $order_status_id = $this->db->escape($order_status_id);
    
        $this->db->query("INSERT INTO `" . DB_PREFIX . "modulus_history` SET order_id = '".$order_id."', phone_number='".$PhoneNumber."', message='".$Message."', order_status_log = '".$order_status_id."' , message_id = '".$messageId."', callback_code = '".$callbackcode."', callback_message = '".$callbackmessage."', created_at = NOW()");
    }

    public function updateLogscus($cus_id, $PhoneNumber, $Message, $order_status_id, $messageId, $callbackcode, $callbackmessage) {
        $cus_id = $this->db->escape($cus_id);
        $PhoneNumber = $this->db->escape($PhoneNumber);
        $Message = $this->db->escape($Message);
        $order_status_id = $this->db->escape($order_status_id);
    
        $this->db->query("INSERT INTO `" . DB_PREFIX . "modulus_history` SET cus_id = '".$cus_id."', phone_number='".$PhoneNumber."', message='".$Message."', order_status_log = '".$order_status_id."' , message_id = '".$messageId."', callback_code = '".$callbackcode."', callback_message = '".$callbackmessage."', created_at = NOW()");
    }
   
   
    public function updateNotifyStatus($id) {
        $this->db->query("UPDATE `" . DB_PREFIX . "modulus_back_in_stock` SET notify_id = 1 WHERE id = " . (int)$id . "");
    }

}

