<?php

class ControllerExtensionModulemodulus extends Controller
{

    public function eventChangeOrder($hook, $input, $output)
    {

     

        if ($this->config->get('modulus_settings_status')) {

            $this->load->model('extension/module/modulus');
            $this->load->model('checkout/order');
            $this->load->model('setting/setting');
            $timelimit =  $this->config->get('modulus_settings_timelimit');
            $order_id = !empty($this->request->get['order_id']) ? $this->request->get['order_id'] : (!empty($input[0]) ? $input[0] : '');
            $store_id = !empty($this->request->get['store_id']) ? $this->request->get['store_id'] : '';
            $cus_id = 0;
            $hourRanges = array(
                'Monday' => array('from' => $this->config->get('modulus_settings_monday_from'), 'to' => $this->config->get('modulus_settings_monday_to')),
                'Tuesday' => array('from' => $this->config->get('modulus_settings_tuesday_from'), 'to' => $this->config->get('modulus_settings_tuesday_to')),
                'Wednesday' => array('from' => $this->config->get('modulus_settings_wednesday_from'), 'to' => $this->config->get('modulus_settings_wednesday_to')),
                'Thursday' => array('from' => $this->config->get('modulus_settings_thursday_from'), 'to' => $this->config->get('modulus_settings_thursday_to')),
                'Friday' => array('from' => $this->config->get('modulus_settings_friday_from'), 'to' => $this->config->get('modulus_settings_friday_to')),
                'Saturday' => array('from' => $this->config->get('modulus_settings_saturday_from'), 'to' => $this->config->get('modulus_settings_saturday_to')),
                'Sunday' => array('from' => $this->config->get('modulus_settings_sunday_from'), 'to' => $this->config->get('modulus_settings_sunday_to'))
            );

            $send_message = true;
            if ($timelimit == 1) {
                date_default_timezone_set('Europe/Athens');
                $currentDay = date('l');
                $currentHour = date('H:i');
                $hasHourRanges = false;
    
                  foreach ($hourRanges as $day => $hourRange) {
                    if ($hourRange['from'] != '' && $hourRange['to'] != '') {
                      
                        $hasHourRanges = true;
    
                        if ($day == $currentDay) {
                            $fromTime = strtotime($hourRange['from']);
                            $toTime = strtotime($hourRange['to']);
                            $currentTime = strtotime($currentHour);

                            if ($currentTime >= $fromTime && $currentTime <= $toTime) {
                              
                                $send_message = true;
                                break;
                            } else {
                            
                                $send_message = false;
                            }
                        }
                    }
                }

                if (!$hasHourRanges) {
                    $send_message = true;
                }
            } else {
                $send_message = true;
            }

           
           
            if($send_message == true){

            if ($order_id) {
                $order_info = $this->model_checkout_order->getOrder($order_id);

                if (!empty($order_info)) {

                    $status_id = $order_info['order_status_id'];

                    $language_id = $order_info['language_id'];

                    $customer_phone = $order_info['telephone'];
                   
                    if ($customer_phone && substr($customer_phone, 0, 3) !== '+30' || substr($customer_phone, 0, 4) !== '0030') {

                        if (substr($customer_phone, 0, 1) === '0') {
                            $customer_phone = substr($customer_phone, 1);
                        }
                        $customer_phone = '+30' . $customer_phone;
                    }



                    $this->load->model('extension/module/modulus');

                    $sms_settings = $this->model_extension_module_modulus->sendSMS($status_id);

                    //$this->log->write('Event triggered sms text ' . $customer_phone);
                    
                    if ($sms_settings && $sms_settings['enabled']) {

                          $this->load->model('setting/setting');

                          require_once(DIR_SYSTEM . 'library/modulus/modulusSend.php');
                          $smsSender = new modulusSend();
                          
                          $smsSender->setUrl($this->config->get('modulus_settings_api_url'));
                          $smsSender->setSenderId($this->config->get('modulus_settings_senderid')); 
                          $smsSender->setApiToken($this->config->get('modulus_settings_api_token')); 
                          $smsSender->setChannel($this->config->get('modulus_settings_channel')); 
                          $smsSender->setCallback($this->url->link('extension/module/modulus/callback', '', true));

                          $Message = $sms_settings['template_text'];
                          $Message = str_replace("{first_name}", $order_info['firstname'], $Message);
                          $Message = str_replace("{last_name}", $order_info['lastname'], $Message);
                          $Message = str_replace("{order_id}", $order_info['order_id'], $Message);
                          $Message = str_replace("{order_total}", $order_info['total'], $Message);

                          $smsSender->addPhone($customer_phone); 
                          $smsSender->addSmsMessage($Message); 
                         
                          list($httpCode, $response) = $smsSender->send();


                          if ($httpCode == 200) {

                            $responseObject = json_decode($response);
                            $messageId = $responseObject->messages[0]->messageId;
                            $callbackcode = $responseObject->messages[0]->status->code;
                            $callbackmessage = $responseObject->messages[0]->status->message;
                
                            $this->model_extension_module_modulus->updateLogs($order_id, $customer_phone, $sms_settings['template_text'], $status_id,$messageId,$callbackcode,$callbackmessage); 
            
                          }

                          

                          //$this->log->write('Event response ' .json_encode($response));
                    }    

             
                }
            }
        }else{
          
            if ($order_id) {
                $order_info = $this->model_checkout_order->getOrder($order_id);
                
                if (!empty($order_info)) {

                    $status_id = $order_info['order_status_id'];

                    $language_id = $order_info['language_id'];

                    $customer_phone = $order_info['telephone'];

                    $order_id = $order_info['order_id'];
                   
                    if ($customer_phone && substr($customer_phone, 0, 3) !== '+30' || substr($customer_phone, 0, 4) !== '0030') {

                        if (substr($customer_phone, 0, 1) === '0') {
                            $customer_phone = substr($customer_phone, 1);
                        }
                        $customer_phone = '+30' . $customer_phone;
                    }

                    

                    $this->load->model('extension/module/modulus');

                    $sms_settings = $this->model_extension_module_modulus->sendSMS($status_id);

                    $this->log->write('Event triggered sms text ' . $customer_phone);
                    
                    if ($sms_settings && $sms_settings['enabled']) {

                          $this->load->model('setting/setting');

                          
                         
                          
                          $this->model_extension_module_modulus->saveForLaterSendingStatus($customer_phone, $sms_settings['template_text'], $order_id);
                        
                          $json['success'] = 'Message saved for later sending.';
                         
                          $this->response->addHeader('Content-Type: application/json');
                          $this->response->setOutput(json_encode($json));

                    }    

             
                }
            }

        }
        }

    }

    public function callback()
    {
        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            $request = json_decode(file_get_contents('php://input'), true);

            $messageId = $request['messageId'];
            $apicode = $request['status']['code'];
            $apimessage = $request['status']['message'];
            
            $this->load->model('extension/module/modulus');
          

            if (!empty($messageId)) {
                $this->log->write('Callback: '. $messageId. ' '.$apicode. ' '.$apimessage);
                $this->model_extension_module_modulus->updateCallback($messageId,$apicode,$apimessage); 
            }
        }
        exit();
    }

    public function back_in_stock() {
        $json = array();
    
      
        if (isset($this->request->post['phone']) && isset($this->request->post['product_id'])) {
            $phone = $this->request->post['phone'];
            $product_id = $this->request->post['product_id'];
    
           
            if (!filter_var($phone, FILTER_SANITIZE_NUMBER_INT)) {
                $json['error'] = 'Invalid phone number.';
            } else {
                
                $this->load->model('extension/module/modulus');
    
              
                $this->model_extension_module_modulus->addBackInStockRequest($phone, $product_id);
    
                $json['success'] = 'Thank you! We will notify you when the product is back in stock.';
            }
        } else {
            $json['error'] = 'Required data is missing.';
        }
    
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }


    public function sendPendingMessages() {
        $this->load->language('extension/module/modulus');
        $this->document->setTitle(strip_tags($this->language->get('heading_title')));
        $this->load->model('setting/setting');
        $this->load->model('extension/module/modulus');

     
    
        $timelimit = $this->config->get('modulus_settings_timelimit');
        $hourRanges = array(
            'Monday' => array('from' => $this->config->get('modulus_settings_monday_from'), 'to' => $this->config->get('modulus_settings_monday_to')),
            'Tuesday' => array('from' => $this->config->get('modulus_settings_tuesday_from'), 'to' => $this->config->get('modulus_settings_tuesday_to')),
            'Wednesday' => array('from' => $this->config->get('modulus_settings_wednesday_from'), 'to' => $this->config->get('modulus_settings_wednesday_to')),
            'Thursday' => array('from' => $this->config->get('modulus_settings_thursday_from'), 'to' => $this->config->get('modulus_settings_thursday_to')),
            'Friday' => array('from' => $this->config->get('modulus_settings_friday_from'), 'to' => $this->config->get('modulus_settings_friday_to')),
            'Saturday' => array('from' => $this->config->get('modulus_settings_saturday_from'), 'to' => $this->config->get('modulus_settings_saturday_to')),
            'Sunday' => array('from' => $this->config->get('modulus_settings_sunday_from'), 'to' => $this->config->get('modulus_settings_sunday_to'))
        );
    

       
            $send_message = true;
            if ($timelimit == 1) {
                date_default_timezone_set('Europe/Athens');
                $currentDay = date('l');
                $currentHour = date('H:i');
                $hasHourRanges = false;
    
                foreach ($hourRanges as $day => $hourRange) {
                    if ($hourRange['from'] != '' && $hourRange['to'] != '') {
                        $hasHourRanges = true;
                        if ($day == $currentDay) {
                            $fromTime = strtotime($hourRange['from']);
                            $toTime = strtotime($hourRange['to']);
                            $currentTime = strtotime($currentHour);
                            if ($currentTime >= $fromTime && $currentTime <= $toTime) {
                                $send_message = true;
                                break;
                            } else {
                                $send_message = false;
                            }
                        }
                    }
                }
                if (!$hasHourRanges) {
                    $send_message = true;
                }
            } else {
                $send_message = true;
            }
             
           
          
            if ($send_message) {
                $pending_messages = $this->db->query("SELECT * FROM `" . DB_PREFIX . "modulus_send_later` WHERE is_sent = 0")->rows;
                foreach ($pending_messages as $message) {
                    $PhoneNumber = $message['phone_number'];
                    $Message = $message['message'];
                    $order_id = $message['order_id'];
                    $cus_id = $message['cus_id'];
                    $order_status_id = $message['order_status_log'];
    
           
                    require_once(DIR_SYSTEM . 'library/modulus/modulusSend.php');
                    $smsSender = new modulusSend();
                    $smsSender->setUrl($this->config->get('modulus_settings_api_url'));
                    $smsSender->setSenderId($this->config->get('modulus_settings_senderid'));
                    $smsSender->setApiToken($this->config->get('modulus_settings_api_token'));
                    $smsSender->setChannel($this->config->get('modulus_settings_channel'));
                    $smsSender->addPhone($PhoneNumber);
                    $smsSender->addSmsMessage($Message);
                    list($httpCode, $response) = $smsSender->send();
                    
                    
                    if ($httpCode == 200) {

                        $responseObject = json_decode($response);
                        $messageId = $responseObject->messages[0]->messageId;
                        $callbackcode = $responseObject->messages[0]->status->code;
                        $callbackmessage = $responseObject->messages[0]->status->message;
                        if ($order_id > 0) {
                        $this->model_extension_module_modulus->updateLogs($order_id, $PhoneNumber, $Message,$order_status_id, $messageId, $callbackcode, $callbackmessage);
                        } else if ($cus_id > 0) {
                            $this->model_extension_module_modulus->updateLogscus($cus_id, $PhoneNumber, $Message, $order_status_id, $messageId, $callbackcode, $callbackmessage);
                        }
                        $json['success'] = $callbackmessage;
                    } else {
                        $json['error'] = 'SMS could not be sent. Response code: ' . $response;
                    }
        
                    $this->response->addHeader('Content-Type: application/json');
                    $this->response->setOutput(json_encode($json));
                        $this->db->query("UPDATE `" . DB_PREFIX . "modulus_send_later` SET is_sent = 1 WHERE id = '" . (int)$message['id'] . "'");
                    
                }
    
          
                $this->session->data['success'] = 'Pending messages sent successfully.';
            }
        
    }

}
