<?php

class ModelExtensionModulemodulus extends Model
{

    public function setHistory($http_code, $errors, $phone, $text, $sending_method, $store_id)
    {
        if (!empty($errors)) {
            foreach ($errors as $error) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "modulus_requests SET `channel` = '" . (!empty($sending_method) ? $sending_method : 'sms') . "', `phone` = '" . $this->db->escape(!empty($error['phone']) ? $error['phone'] : $phone) . "', `message` = '" . $this->db->escape($text) . "', `message_id` = '" . $this->db->escape(!empty($error['message_id']) ? $error['message_id'] : '') . "', `status` = '" . $this->db->escape($http_code) . "', `error` = '" . $this->db->escape($error['text']) . "', `type` = '" . $this->db->escape($error['type']) . "', `created_at` = '" . date('Y-m-d H:i:s') . "', `updated_at` = '" . date('Y-m-d H:i:s') . "', `store_id` = '" . (int)$this->db->escape($store_id) . "'");
            }
        } else {
            $this->db->query("INSERT INTO " . DB_PREFIX . "modulus_requests SET `channel` = '" . (!empty($sending_method) ? $sending_method : 'sms') . "', `phone` = '" . $this->db->escape($phone) . "', `message` = '" . $this->db->escape($text) . "', `message_id` = '" . $this->db->escape('') . "', `status` = '" . $this->db->escape($http_code) . "', `error` = '" . $this->db->escape('') . "', `type` = '" . $this->db->escape('') . "', `created_at` = '" . date('Y-m-d H:i:s') . "', `updated_at` = '" . date('Y-m-d H:i:s') . "', `store_id` = '" . (int)$this->db->escape($store_id) . "'");
        }
    }

    public function saveForLaterSendingStatus($customer_phone, $sms_settings, $order_id) {
        $this->db->query("INSERT INTO `" . DB_PREFIX . "modulus_send_later` (phone_number, message, order_id, cus_id,order_status_log) VALUES ('" . $this->db->escape($customer_phone) . "', '" . $this->db->escape($sms_settings) . "','" . $this->db->escape($order_id) . "','" . $this->db->escape($cus_id) . "','" . $this->db->escape($status_id) . "')");
    }

    public function send($phone, $text, $store_id)
    {
        if (!empty($text)) {
            require_once DIR_SYSTEM . '/library/modulus/modulusSend.php';
            $modulusSend = new modulusSend();
            $modulusSend->setOptionsCallback($this->url->link('extension/module/modulus/callback', '', true));
            $modulusSend->addPhone($phone);

            $modulus_login = $this->config->get('modulus_settings_modulus_login');
            $from = $this->config->get('modulus_settings_senderid');
            $sending_method = $this->config->get('modulus_settings_channel');

            switch ($sending_method) {
                case 'viber':
                    $modulusSend->setFromViber($from);
                    $modulusSend->addViberMessage($text);
                    break;
                case 'whatsapp':
                    $modulusSend->setFromWhatsapp($from);
                    $modulusSend->addWhatsappMessage($text);
                    break;
                case 'vk':
                    $modulusSend->setFromVk($from);
                    $modulusSend->addVkMessage($text);
                    break;
                default:
                    $modulusSend->setFromSms($from);
                    $modulusSend->addSmsMessage($text);
            }
            $modulusSend->setmodulusLogin($modulus_login);
            list($http_code,) = $modulusSend->send();
            $errors = $modulusSend->getErrors();

            $this->setHistory($http_code, $errors, $phone, $text, !empty($settings['sending_method']) ? $settings['sending_method'] : '', $store_id);
        }
    }

    private function shortcodeParseAtts($text)
    {
        $atts = [];
        $pattern = '/([\w-]+)\s*=\s*"([^"]*)"(?:\s|$)|([\w-]+)\s*=\s*\'([^\']*)\'(?:\s|$)|([\w-]+)\s*=\s*([^\s\'"]+)(?:\s|$)|"([^"]*)"(?:\s|$)|\'([^\']*)\'(?:\s|$)|(\S+)(?:\s|$)/';
        $text = preg_replace("/[\x{00a0}\x{200b}]+/u", " ", $text);
        if (preg_match_all($pattern, $text, $match, PREG_SET_ORDER)) {
            foreach ($match as $m) {
                if (!empty($m[1]))
                    $atts[strtolower($m[1])] = stripcslashes($m[2]);
                else if (!empty($m[3]))
                    $atts[strtolower($m[3])] = stripcslashes($m[4]);
                else if (!empty($m[5]))
                    $atts[strtolower($m[5])] = stripcslashes($m[6]);
                else if (isset($m[7]) && strlen($m[7]))
                    $atts[] = stripcslashes($m[7]);
                else if (isset($m[8]) && strlen($m[8]))
                    $atts[] = stripcslashes($m[8]);
                else if (isset($m[9]))
                    $atts[] = stripcslashes($m[9]);
            }

            // Reject any unclosed HTML elements
            foreach ($atts as &$value) {
                if (false !== strpos($value, '<')) {
                    if (1 !== preg_match('/^[^<]*+(?:<[^>]*+>[^<]*+)*+$/', $value)) {
                        $value = '';
                    }
                }
            }
        } else {
            $atts = ltrim($text);
        }
        return $atts;
    }

    public function parseShortcodeOrder($text, $order, $return_order = false)
    {
        $shortcodes = [
            "order_id",
            "firstname",
            "lastname",
            "email",
            "telephone",
            "date_added",
            "payment_method",
            "shipping_method",
            "ip",
            "payment_address",
            "shipping_address",
            "products",
            "order_comment",
            "store_name",
            "store_url",
            "order_amount",
        ];
        foreach ($shortcodes as $shortcode) {
            if (preg_match_all('|\[' . $shortcode . '(.*)\]|isU', $text, $arr)) {
                if (!empty($arr[0])) {
                    foreach ($arr[0] as $key => $value) {
                        $attr = $this->shortcodeParseAtts(!empty($arr[1][$key]) ? $arr[1][$key] : '');
                        $before = !empty($attr['before']) ? $attr['before'] : '';
                        $after = !empty($attr['after']) ? $attr['after'] : '';

                        $replace_text = '';
                        switch ($shortcode) {
                            case "order_id":
                                if ($return_order)
                                    $replace_text = !empty($return_order['order_id']) ? $return_order['order_id'] : '';
                                else
                                    $replace_text = !empty($order['order_id']) ? $order['order_id'] : '';
                                break;
                            case "firstname":
                                if ($return_order)
                                    $replace_text = !empty($return_order['firstname']) ? $return_order['firstname'] : (!empty($order['firstname']) ? $order['firstname'] : (!empty($order['payment_firstname']) ? $order['payment_firstname'] : (!empty($order['shipping_firstname']) ? $order['shipping_firstname'] : '')));
                                else
                                    $replace_text = !empty($order['firstname']) ? $order['firstname'] : (!empty($order['payment_firstname']) ? $order['payment_firstname'] : (!empty($order['shipping_firstname']) ? $order['shipping_firstname'] : ''));
                                break;
                            case "lastname":
                                if ($return_order)
                                    $replace_text = !empty($return_order['lastname']) ? $return_order['lastname'] : (!empty($order['lastname']) ? $order['lastname'] : (!empty($order['payment_lastname']) ? $order['payment_lastname'] : (!empty($order['shipping_lastname']) ? $order['shipping_lastname'] : '')));
                                else
                                    $replace_text = !empty($order['lastname']) ? $order['lastname'] : (!empty($order['payment_lastname']) ? $order['payment_lastname'] : (!empty($order['shipping_lastname']) ? $order['shipping_lastname'] : ''));
                                break;
                            case "email":
                                if ($return_order)
                                    $replace_text = !empty($return_order['email']) ? $return_order['email'] : '';
                                else
                                    $replace_text = !empty($order['email']) ? $order['email'] : '';
                                break;
                            case "telephone":
                                if ($return_order)
                                    $replace_text = !empty($return_order['telephone']) ? $return_order['telephone'] : '';
                                else
                                    $replace_text = !empty($order['telephone']) ? $order['telephone'] : '';
                                break;
                            case "date_added":
                                if ($return_order)
                                    $replace_text = !empty($return_order['date_added']) ? $return_order['date_added'] : '';
                                else
                                    $replace_text = !empty($order['date_added']) ? $order['date_added'] : '';
                                break;
                            case "payment_method":
                                $replace_text = !empty($order['payment_method']) ? $order['payment_method'] : '';
                                break;
                            case "shipping_method":
                                $replace_text = !empty($order['shipping_method']) ? $order['shipping_method'] : '';
                                break;
                            case "ip":
                                $replace_text = !empty($order['forwarded_ip']) ? $order['forwarded_ip'] : '';
                                break;
                            case "payment_address":
                                $replace_text = !empty($order['payment_address_1']) ? $order['payment_address_1'] : '';
                                break;
                            case "shipping_address":
                                $replace_text = !empty($order['shipping_address_1']) ? $order['shipping_address_1'] : '';
                                break;
                            case "products":
                                $replace_text = '';

                                if ($return_order)
                                    $replace_text = !empty($return_order['product']) ? ($return_order['product'] . ' * ' . $return_order['quantity']) : '';
                                else {
                                    $order_product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int)(!empty($order['order_id']) ? $order['order_id'] : '') . "'");
                                    foreach ($order_product_query->rows as $product) {
                                        if (end($order_product_query->rows) == $product)
                                            $replace_text .= $product['name'] . ' * ' . $product['quantity'];
                                        else
                                            $replace_text .= $product['name'] . ' * ' . $product['quantity'] . ', ';
                                    }
                                }

                                break;
                            case "order_comment":
                                if ($return_order)
                                    $replace_text = !empty($return_order['comment']) ? $return_order['comment'] : '';
                                else
                                    $replace_text = !empty($order['comment']) ? $order['comment'] : '';
                                break;
                            case "store_name":
                                $replace_text = !empty($order['store_name']) ? $order['store_name'] : '';
                                break;
                            case "store_url":
                                $replace_text = !empty($order['store_url']) ? $order['store_url'] : '';
                                break;
                            case "order_amount":
                                if ($return_order)
                                    $replace_text = '';
                                else
                                    $replace_text = $this->currency->format($order['total'], $order['currency_code']);
                                break;
                        }
                        if (!empty($replace_text))
                            $replace_text = $before . $replace_text . $after;

                        $text = str_replace($value, $replace_text, $text);
                    }
                }
            }
        }
        return $text;
    }



   
    public function sendSMS($order_status_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_orders_board WHERE order_status_id = '" . (int)$order_status_id . "' and send_sms = 1");

        $sms_settings = [];

        if($query->row){
            $template = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_templates WHERE id = '" . (int)$query->row['template_id'] . "'");

            return array(
                'enabled' => true,
                'template_text' => $template->row['message']
            );

        }else{
            return false;
        }
       
    }



    public function getTemplateByAction($store_id, $action, $language_id)
    {
        if ($store_id === false && $language_id === false) {
            $templates = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_templates WHERE `action` = '" . $this->db->escape($action) . "' AND `active` = true");
        } else
            $templates = $this->db->query("SELECT * FROM " . DB_PREFIX . "modulus_templates WHERE `store_id` = '" . (int)$store_id . "' AND `language` = '" . (int)$language_id . "' AND `action` = '" . $this->db->escape($action) . "' AND `active` = true");
        return $templates->rows;
    }

    public function addBackInStockRequest($phone, $product_id) {
        $this->db->query("INSERT INTO `" . DB_PREFIX . "modulus_back_in_stock` SET phone = '" . $this->db->escape($phone) . "', product_id = '" . (int)$product_id . "', notify_id = 0");
    }


    public function updateCallback($messageId,$apicode,$apimessage) {

        $messageId = $this->db->escape($messageId);
        $callbackcode = $this->db->escape($apicode);
        $callbackmessage = $this->db->escape($apimessage);
    
        $this->log->write("UPDATE modulus_history");
        $this->db->query("UPDATE `" . DB_PREFIX . "modulus_history` SET  callback_code='".$callbackcode."', callback_message='".$callbackmessage."' WHERE message_id = '".$messageId."' ");
       
    }


    public function updateLogs($order_id, $PhoneNumber, $Message, $order_status_id, $messageId, $callbackcode, $callbackmessage) {
        $order_id = $this->db->escape($order_id);
        $PhoneNumber = $this->db->escape($PhoneNumber);
        $Message = $this->db->escape($Message);
        $order_status_id = $this->db->escape($order_status_id);
    
        $this->db->query("INSERT INTO `" . DB_PREFIX . "modulus_history` SET order_id = '".$order_id."', phone_number='".$PhoneNumber."', message='".$Message."', order_status_log = '".$order_status_id."' , message_id = '".$messageId."', callback_code = '".$callbackcode."', callback_message = '".$callbackmessage."', created_at = NOW()");
    }

    public function updateLogscus($cus_id, $PhoneNumber, $Message, $order_status_id, $messageId, $callbackcode, $callbackmessage) {
        $cus_id = $this->db->escape($cus_id);
        $PhoneNumber = $this->db->escape($PhoneNumber);
        $Message = $this->db->escape($Message);
        $order_status_id = $this->db->escape($order_status_id);
    
        $this->db->query("INSERT INTO `" . DB_PREFIX . "modulus_history` SET cus_id = '".$cus_id."', phone_number='".$PhoneNumber."', message='".$Message."', order_status_log = '".$order_status_id."' , message_id = '".$messageId."', callback_code = '".$callbackcode."', callback_message = '".$callbackmessage."', created_at = NOW()");
    }

}
