<?php

class modulusSend
{

    private $url = '';
    private $channel = '';
    private $phone = '';
    private $SmsMessage = '';

    private $sms = [];
    private $fromSms = '';

    private $viber = [];
    private $fromViber = '';

    private $viber2sms = [];
    private $fromviber2sms = '';

    private $options = [
        "ttl" => 30,
    ];

    private $errors = [];

    /**
     * modulusSend constructor.
     */
    public function __construct()
    {
    }

   

    public function getData()
    {
        $recipients = [];
        
        $recipients[] = ['msisdn' => $this->phone];

    
        $data = [
            'priority' => 3,
            'recipients'   => $recipients,
            'dlr'    => true,
            'dlrUrl'    => $this->callback,
            'externalTags'    => ['string'],
        ];
        

        switch ($this->channel) {
            case 'sms':

               
                $smsdata = [
                    "sender" => $this->fromSms, 
                    "text" => $this->SmsMessage, 
                    "encoding" => 'gsm', 
                    "validityPeriod" => 86400
                ];

                $data['sms'] = $smsdata;

                break;
            case 'viber':

                $viberdata = [
                    "sender" => $this->fromSms, 
                    'type' => 'text',
                    "text" => $this->SmsMessage, 
                    "encoding" => 'gsm', 
                    "validityPeriod" => 86400
                ];

                $data['viber'] = $viberdata;
                $data['routing'] = 'viberTransactional';
              

                break;
            case 'viber2sms':
                
                $viber2sms = [
                    "sender" => $this->fromSms, 
                    'type' => 'text',
                    "text" => $this->SmsMessage, 
                    "encoding" => 'gsm', 
                    "validityPeriod" => 86400
                ];

                $data['viber'] = $viber2sms;

                $smsdata = [
                    "sender" => $this->fromSms, 
                    "text" => $this->SmsMessage, 
                    "encoding" => 'gsm', 
                    "validityPeriod" => 86400
                ];

                $data['sms'] = $smsdata;
                $data['routing'] = 'viberTransactional2SMS';

                break;
        }

        
        return  json_encode($data);
    }

    public function send()
    {
        $data = $this->getData();
        
      
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $this->ApiToken
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 45);
        $output = curl_exec($ch);
        $info = curl_getinfo($ch);
        curl_close($ch);
        $this->checkErrors($info['http_code'], $output);

        return [$info['http_code'], $output];
        
    }

    private function checkErrors($http_code, $output)
    {
        $output = json_decode($output, true);
      
        switch ($http_code) {
            case 0:
                $this->addError(['type' => 'danger', 'text' => 'Your request has been sent, but the result of the operation has not been received']);
                break;
            case 500:
                $this->addError(['type' => 'danger', 'text' => 'Internal error, try again later']);
                break;
            case 200:
                if (!empty($output['messages']))
                    foreach ($output['messages'] as $message) {
                        $text = '';
                        if (isset($message['recipient']['phone']))
                            $text .= $message['recipient']['phone'] . ' - ';
                        if (isset($message['error'])) {
                            $text .= $message['error']['title'] . ' (' . $message['error']['detail'] . ')';
                            $this->addError(['type' => 'danger', 'text' => $text, 'phone' => !empty($message['recipient']['phone']) ? $message['recipient']['phone'] : null]);
                        } else {
                            $text .= 'Request accepted for processing';
                            $this->addError(['type' => 'success', 'text' => $text, 'phone' => !empty($message['recipient']['phone']) ? $message['recipient']['phone'] : null]);
                        }
                    }
                break;
            default:
                $this->addError(['type' => 'warning', 'text' => $output['title'] . ' (' . $output['detail'] . ')']);
                break;

        }
    }

    /**
     * @return array
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param array $error
     */
    public function addError(array $error)
    {
        $this->errors[] = $error;
    }


    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }


    public function setSenderId($id)
    {
        $this->fromSms = $id; 
    }

    public function setApiToken($ApiToken)
    {
        $this->ApiToken = $ApiToken; 
    }


    public function setCallback($callback)
    {
        $this->callback = $callback; 
    }


    public function setChannel($channel) {
        $this->channel = $channel;
    }


    /**
     * @return array
     */
    public function getPhones()
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     */
    public function addPhone($phone)
    {
        $this->phone = preg_replace("/[^0-9]/", '', $phone);
    }



    public function addSmsMessage($SmsMessage)
    {
        $this->SmsMessage = $SmsMessage;
    }

    /**
     *
     * @param int $ttl
     */
    public function setOptionsTtl($ttl)
    {
        $this->options['ttl'] = $ttl;
    }

    /**
     *
     * @param string $callback
     */
    public function setOptionsCallback($callback)
    {
      
     $this->callback = $callback;
       
    }

    public function getOptionsCallback()
    {
        return $this->callback;
    }
    /**
     *
     * @param string $external_id
     */
    public function setOptionsExternalId($external_id)
    {
        if (!empty($external_id))
            $this->options['external_id'] = $external_id;
        else unset($this->options['external_id']);
    }

    /**
     * @return int[]
     */
    public function getOptions()
    {
        return $this->options;
    }


    /**
     * @return string
     */
    public function getFromSms()
    {
        return $this->fromSms;
    }

    /**
     *
     *
     * @param string $fromSms
     */
    public function setFromSms($fromSms)
    {
        $this->fromSms = $fromSms;
    }

    /**
     * @return string
     */
    public function getFromViber()
    {
        return $this->fromViber;
    }

    /**
     *
     *
     * @param string $fromViber
     */
    public function setFromViber($fromViber)
    {
        $this->fromViber = $fromViber;
    }

    /**
     * @return array
     */
    public function getviber2sms()
    {
        return $this->viber2sms;
    }

    /**
     *
     *
     * @param array $viber2sms
     */
    public function setviber2sms(array $viber2sms)
    {
        $this->viber2sms = $viber2sms;
    }

    /**
     * @return string
     */
    public function getFromviber2sms()
    {
        return $this->fromviber2sms;
    }

    /**
     *
     *
     * @param string
     */
    public function setFromviber2sms($fromviber2sms)
    {
        $this->fromviber2sms = $fromviber2sms;
    }

   
 
}
