<?php

//adds settings to woocommerce menu

function woo_sms_alerts_add_to_menu()
{
    add_submenu_page(
        'woocommerce',
        __('SMS Alerts Settings', 'woo-sms-alerts'),
        __('Customer SMS', 'woo-sms-alerts'),
        'manage_woocommerce',
        'woo-sms-mass',
        'woo_sms_alerts_settings_page'
    );
    add_submenu_page(
        'woocommerce',
        __('SMS Alerts Settings', 'woo-sms-alerts'),
        __('SMS Settings', 'woo-sms-alerts-mass'),
        'manage_woocommerce',
        'woo-sms-alerts-settings',
        'woo_sms_alerts_settings_page'
    );


}
add_action('admin_menu', 'woo_sms_alerts_add_to_menu');


function get_order_board_data_with_status_names()
{
    $orders_data = get_order_board_data();
    $order_statuses = wc_get_order_statuses();

    foreach ($orders_data as &$order) {
        $order['order_status'] = isset($order_statuses[$order['order_status']]) ? $order_statuses[$order['order_status']] : $order['order_status'];
    }

    return $orders_data;
}


// Display the settings page
function woo_sms_alerts_settings_page()
{
    $active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'configuration';
    ?>
    <div class="wrap">
        <h1><b>
                <?php _e('Settings SMS', 'woo-sms-alerts'); ?>
            </b></h1>

        <h2 class="nav-tab-wrapper">
            <a href="?page=woo-sms-settings&tab=configuration"
                class="nav-tab <?php echo $active_tab == 'configuration' ? 'nav-tab-active' : ''; ?>">Configuration</a>
            <a href="?page=woo-sms-settings&tab=test-sms"
                class="nav-tab <?php echo $active_tab == 'test-sms' ? 'nav-tab-active' : ''; ?>">Test SMS</a>
            <a href="?page=woo-sms-settings&tab=templates"
                class="nav-tab <?php echo $active_tab == 'templates' ? 'nav-tab-active' : ''; ?>">Πρότυπα</a>
            <a href="?page=woo-sms-settings&tab=order-state"
                class="nav-tab <?php echo $active_tab == 'order-state' ? 'nav-tab-active' : ''; ?>">Καταστάσεις
                Παραγγελιών</a>
            <a href="?page=woo-sms-settings&tab=log-tab"
                class="nav-tab <?php echo $active_tab == 'log-tab' ? 'nav-tab-active' : ''; ?>">BackInStock Logs</a>
            <a href="?page=woo-sms-settings&tab=constraints"
                class="nav-tab <?php echo $active_tab == 'constraints' ? 'nav-tab-active' : ''; ?>">Χρονοπεριορισμός</a>
            <a href="?page=woo-sms-settings&tab=consent"
                class="nav-tab <?php echo $active_tab == 'consent' ? 'nav-tab-active' : ''; ?>">SMS Consent</a>
        </h2>
        </h2>

        <?php
        if ($active_tab == 'configuration') { ?>
            <style>
                .modulus-form-configuration table {
                    width: fit-content !important;
                }
            </style>
            <form method="post" class="modulus-form-configuration" action="options.php">

                <?php

                settings_fields('woo_sms_alerts_settings');
                do_settings_sections('woo-sms-alerts-settings');
                submit_button();
                ?>
            </form>

            <?php
        } elseif ($active_tab == 'test-sms') { ?>

            <form method="post" class="modulus-form-configuration" action="modulus_send_test_sms">
                <?php
                settings_fields('woo_sms_alerts_test_sms_settings');
                do_settings_sections('woo-sms-alerts-test-sms-settings');
                woo_sms_alerts_send_test_sms_button_callback();
                ?>
            </form>
            <?php
        } elseif ($active_tab == 'templates') {

            $presets = get_presets();
            echo '<div class="modulus-sms-templates">';
            echo '<button class="add-template-button modulus-add-button" data-template-id=""><img src="' . plugin_dir_url(__FILE__) . 'assets/images/addbutton.png" alt="Add"></button>';
            echo '<table class="wp-list-table widefat fixed striped">';

            echo '<table class="wp-list-table widefat fixed striped modulus-sms-table">';
            echo '<thead><tr><th width="5%">ID</th><th width="45%">Title</th><th width="20%">Creation Date</th><th width="20%">Last Edit Date</th><th class="actions-column" width="10%">Actions</th></tr></thead>';
            echo '<tbody>';
            foreach ($presets as $preset) {
                echo '<tr>';
                echo '<td>' . esc_html($preset['id']) . '</td>';
                echo '<td>' . esc_html($preset['title']) . '</td>';
                echo '<td>' . esc_html($preset['creation_date']) . '</td>';
                echo '<td>' . esc_html($preset['last_edit_date']) . '</td>';
                echo '<td class="actions-column"><button class="edit-template-button" data-template-id="' . esc_attr($preset['id']) . '" data-title="' . esc_attr($preset['title']) . '" data-message="' . esc_attr($preset['message']) . '"><img src="' . plugin_dir_url(__FILE__) . 'assets/images/editbutton.png" alt="Edit"></button> <button class="delete-template-button" data-template-id="' . esc_attr($preset['id']) . '"><img src="' . plugin_dir_url(__FILE__) . 'assets/images/deletebutton.png" alt="Delete"></button></td>';
                echo '</tr>';
            }
            echo '</tbody>';
            echo '</table>';
            echo '</div>';

            ?>

            <script>
                jQuery(document).ready(function ($) {
                    // Handle delete button click
                    $('.delete-template-button').on('click', function () {
                        var templateId = $(this).data('template-id');

                        if (confirm('Are you sure you want to delete this template?')) {
                            // Send AJAX request to delete template
                            $.ajax({
                                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                                method: 'POST',
                                data: {
                                    action: 'delete_template',
                                    template_id: templateId
                                },
                                success: function (response) {
                                    // Handle success response if needed
                                    // Reload the templates tab after deletion

                                    //alert(JSON.stringify(response));
                                    location.reload();
                                },
                                error: function (error) {
                                    // Handle error response if needed
                                    console.error(error);
                                }
                            });
                        }
                    });

                    $('.close').on('click', function () {
                        // Hide the modal when the "X" button is clicked
                        $('#character_count').empty();
                        $('#character_warning').empty();
                        $('#editTemplateModal').css('display', 'none');
                    });


                    // Handle edit button click
                    $('.add-template-button').on('click', function () {

                        var templateId = '';
                        var templateTitle = '';
                        var templateMessage = '';

                        // Pre-fill modal fields with template data
                        $('#edit-template-title').val(templateTitle);
                        $('#edit-template-message').val(templateMessage);
                        $('#edit-template-id').val(templateId);


                        $('#template-save-type').val('add');


                        // Show the modal
                        $('#editTemplateModal').show();
                    });

                    // Handle edit button click
                    $('.edit-template-button').on('click', function () {
                        var templateId = $(this).data('template-id');
                        var templateTitle = $(this).data('title');
                        var templateMessage = $(this).data('message');

                        // Pre-fill modal fields with template data
                        $('#edit-template-title').val(templateTitle);
                        $('#edit-template-message').val(templateMessage);
                        $('#edit-template-id').val(templateId);
                        $('#template-save-type').val('edit');

                        var charCount = $("#edit-template-message").val().length;

                        var result;

                        if (charCount >= 160 && charCount <= 306) {
                            result = 2;
                        } else if (charCount > 306) {

                            result = Math.ceil((charCount - 306) / 156) + 2;
                        } else {
                            result = 1;
                        }


                        $('#character_count').html("<strong>" + charCount + "</strong>" + " Χαρακτήρες");
                        $('#character_warning').html("Το μήνυμα θα αποσταλεί σε <strong>" + result + " </strong> SMS");

                        // Show the modal
                        $('#editTemplateModal').show();
                    });

                    $('#save-changes-button').on('click', function () {
                        var templateId = $('#edit-template-id').val();
                        var updatedTitle = $('#edit-template-title').val();
                        var updatedMessage = $('#edit-template-message').val();
                        var save_type = $('#template-save-type').val();



                        // Send AJAX request to update template
                        $.ajax({
                            url: '<?php echo admin_url('admin-ajax.php'); ?>',
                            method: 'POST',
                            data: {
                                action: 'update_template',
                                template_id: templateId,
                                updated_title: updatedTitle,
                                save_type: save_type,
                                updated_message: updatedMessage
                            },
                            success: function (response) {
                                // Handle success response if needed
                                console.log(response);

                                // Close the modal after successful update
                                $('#editTemplateModal').hide();

                                // Reload the templates tab to reflect the changes
                                location.reload();
                            },
                            error: function (error) {
                                // Handle error response if needed
                                console.error(error);
                            }
                        });
                    });

                });
            </script>
            <?php
        } elseif ($active_tab == 'order-state') {


            $orders_data = get_order_board_data_with_status_names(); // Fetch order board data with status names
    
            echo '<div class="modulus-order-statuses">';
            echo '<table class="wp-list-table widefat fixed striped modulus-sms-table-order order-status-fixed custom-table-edit">';
            echo '<thead><tr><th width="20%">ID</th><th width="30%">Order Status</th><th width="20%">SMS Sent</th><th width="30%">Order Template ID</th></tr></thead>';
            echo '<tbody>';
            foreach ($orders_data as $order) {
                echo '<tr orderId="' . esc_attr($order['id']) . '" orderTemplate="' . esc_html($order['order_template']) . '">';
                echo '<td>' . esc_html($order['id']) . '</td>';
                echo '<td>' . esc_html($order['order_status']) . '</td>';
                echo '<td>';
                $imageSrc = $order['sms_sent'] ? '' . plugin_dir_url(__FILE__) . 'assets/images/greentick.png' : '' . plugin_dir_url(__FILE__) . 'assets/images/redx.png';
                echo '<div class="custom-control custom-switch">';
                echo '<img src="' . esc_url($imageSrc) . '" alt="' . esc_attr($order['sms_sent'] ? 'Yes' : 'No') . '" id="sms-sent-' . esc_attr($order['id']) . '" class="sms-sent-image">';
                echo '<select order-id="' . esc_attr($order['id']) . '" class="sms-dropdown-status">
                  <option ' . ($order['sms_sent'] == 0 ? 'selected' : '') . ' value="0">NO</option>
                  <option ' . ($order['sms_sent'] == 1 ? 'selected' : '') . ' value="1">YES</option></select>
                  </div>';
                echo '</td>';
                echo '<td>' . esc_html($order['order_template']) . '</td>';
                echo '</tr>';
            }
            echo '</tbody>';
            echo '</table>';
            echo '</div>';

        } elseif ($active_tab == 'log-tab') {

            if (!class_exists('WP_List_Table')) {
                require_once (ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
            }

            class My_Custom_Table extends WP_List_Table
            {



                public function prepare_items()
                {
                    $per_page = 10;


                    $columns = $this->get_columns();
                    $hidden = array();
                    $sortable = $this->get_sortable_columns();
                    $this->_column_headers = array($columns, $hidden, $sortable);


                    global $wpdb;
                    $table_name = $wpdb->prefix . 'modulus_woo_back_in_stock';
                    $data = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE notify_id = %d", 1), ARRAY_A);


                    foreach ($data as $key => $item) {
                        $product = wc_get_product($item['product_id']);
                        $data[$key]['product_name'] = $product ? $product->get_name() : 'Product not found';
                    }


                    $current_page = $this->get_pagenum();
                    $total_items = count($data);
                    $data = array_slice($data, (($current_page - 1) * $per_page), $per_page);


                    $this->set_pagination_args([
                        'total_items' => $total_items,
                        'per_page' => $per_page,
                        'total_pages' => ceil($total_items / $per_page)
                    ]);


                    $this->items = $data;
                }

                public function get_columns()
                {
                    $columns = array(
                        'product_id' => 'Product ID',
                        'product_name' => 'Product Name',
                        'phone_number' => 'Phone Number',

                    );
                    return $columns;
                }

                public function column_default($item, $column_name)
                {
                    switch ($column_name) {
                        case 'product_id':
                        case 'phone_number':
                        case 'product_name':
                            return $item[$column_name];
                        default:
                            return print_r($item, true);
                    }
                }
            }


            $myListTable = new My_Custom_Table();
            $myListTable->prepare_items();
            $myListTable->display();
        } else if ($active_tab == 'constraints') {
            echo time_constraints_admin_content();
        } else if ($active_tab == 'consent') {
            echo consent_tab_contents();
        }

        ?>
        <script>
            jQuery(document).ready(function ($) {

                $('.toggle-sms-sent').each(function () {
                    var orderId = $(this).data('order-id');
                    var savedValue = localStorage.getItem('sms-sent-' + orderId);
                    if (savedValue) {
                        var imageElement = $('#sms-sent-' + orderId);
                        imageElement.attr('src', savedValue);
                    }
                });



                $('.sms-dropdown-status').change(function () {

                    var orderId = $(this).attr('order-id');
                    var setStatus = $(this).val();

                    var imageElement = $('#sms-sent-' + orderId);
                    var currentSrc = imageElement.attr('src');
                    var newValue = currentSrc === '<?php echo plugin_dir_url(__FILE__); ?>assets/images/greentick.png'
                        ? '<?php echo plugin_dir_url(__FILE__); ?>assets/images/redx.png'
                        : '<?php echo plugin_dir_url(__FILE__); ?>assets/images/greentick.png';


                    imageElement.attr('src', newValue);


                    localStorage.setItem('sms-sent-' + orderId, newValue);


                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: 'POST',
                        data: {
                            action: 'toggle_sms_sent',
                            order_id: orderId,
                            setStatus: setStatus
                        },
                        success: function (response) {
                            if (response.success) {

                                $('#sms-sent-' + orderId).text(newValue);


                                $('.toggle-sms-sent[data-order-id="' + orderId + '"]').toggleClass('active', newValue === 'Yes');
                            } else {

                            }
                        },
                        error: function (xhr, status, error) {

                        }
                    });
                });
            });

        </script>
        <script>
            jQuery(document).ready(function ($) {


                // COUNT CHARACTERS FOR TEMPLATE
                $('#editTemplateModal #edit-template-message').on('input', function () {
                    var charCount = $(this).val().length;
                    var result;

                    if (charCount >= 160 && charCount <= 306) {
                        result = 2;
                    } else if (charCount > 306) {

                        result = Math.ceil((charCount - 306) / 156) + 2;
                    } else {
                        result = 1;
                    }


                    $('#character_count').html("<strong>" + charCount + "</strong>" + " Χαρακτήρες");
                    $('#character_warning').html("Το μήνυμα θα αποσταλεί σε <strong>" + result + " </strong> SMS");

                });

                var templates = <?php echo json_encode(get_template_titles()); ?>;


                var dropdown = '<select class="template-dropdown dropdown-edit"><option value="0">Επιλέξτε</option>';

                templates.forEach(function (template) {
                    dropdown += '<option value="' + template.id + '">' + template.title + '</option>';
                });
                dropdown += '</select>';


                $('.modulus-sms-table-order tbody tr').each(function () {
                    var lastCell = $(this).find('td:last');


                    lastCell.html(dropdown);



                    var selectedTemplate = $(this).attr('orderTemplate');
                    if (selectedTemplate) {
                        lastCell.find('.template-dropdown').val(selectedTemplate);
                    }
                });


                $('.template-dropdown').on('change', function () {
                    var orderId = $(this).closest('tr').attr('orderId');
                    var selectedTemplateId = $(this).val();


                    saveSelectedTemplate(orderId, selectedTemplateId);
                });


                function saveSelectedTemplate(orderId, templateId) {
                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: 'POST',
                        data: {
                            action: 'save_selected_template',
                            order_id: orderId,
                            template_id: templateId
                        },
                        success: function (response) {
                            if (response.success) {

                            } else {

                            }
                        },
                        error: function (xhr, status, error) {

                        }
                    });
                }


            });

        </script>

        <div id="editTemplateModal" class="modal small-modal">
            <div class="modal-content" style="width:500px!important;">
                <div style="display:flex;justify-content: space-between;">
                    <h2><b>Επεξεργασία Προτύπου</b></h2>
                    <span class="close" style="display: flex;
    justify-content: flex-end;">&times;</span>

                </div>
                <div class="row template-title-row">
                    <label class="template-title-edit" for="edit-template-title">Τίτλος</label> <br />
                    <input type="text" id="edit-template-title" class="form-control modulus-input padded-field">
                </div>
                <div class="row padded-message" style="margin-bottom:1em;">
                    <?php echo sms_instructions_text();
                    echo instructions_sms_list("order");
                    ?>


                </div>

                <div class="row padded-message">

                    <label class="template-message-edit" for="edit-template-message">Μήνυμα</label><br />
                    <textarea id="edit-template-message" class="form-control"></textarea>

                    <div style="margin-top:1em!important;display:flex;justfy-content:flex-end;width:100%!important;">

                        <span id="character_count"></span>
                        &nbsp;
                        <span id="character_warning"></span>

                    </div>

                </div>

                <input type="hidden" id="edit-template-id" value="">
                <input type="hidden" id="template-save-type" value="">
                <div class="row" style="margin-top:1em;">
                    <button id="save-changes-button" class="modulus-button-submit">Αποθήκευση</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        jQuery(document).ready(function ($) {

            $('#modulus_test_sms').on('click', function (e) {
                e.preventDefault();
                var smsMessage = $('#modulus_sms_test_message').val();
                var smsphone = $('#modulus_sms_test_phone').val();

                // Check if the message box is empty
                if (smsMessage.trim() === '') {
                    // Show a warning message
                    alert('Please enter a message before sending.');
                } else {

                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        method: 'POST',
                        data: {
                            action: 'modulus_send_test_sms',
                            phoneNumber: smsphone,
                            message: smsMessage
                        },
                        success: function (response) {
                            console.log(response)
                            alert(response.data.message)
                            // if (response.data.httpcode == 401) {
                            //     var dataObject = JSON.parse(response.data.response);

                            //     var message = dataObject.message;
                            //     alert(message);
                            // } else {
                            //     alert('Message Sent')
                            // }
                            // console.log()


                            // alert(message);
                            $('#modulus_sms_test_message').val('');
                            $('#modulus_sms_test_phone').val('');

                        },
                        error: function (error) {



                            $('#modulus_sms_test_message').val('');
                            $('#modulus_sms_test_phone').val('');
                        }
                    });



                }
            });
        });



    </script>
    <?php
}


function update_sms_consent_status()
{

    $consent_status = isset($_POST['consent_status']) ? $_POST['consent_status'] : 0;

    update_option('sms_consent_status', $consent_status);

    wp_send_json_success('Option updated successfully!');

}

add_action('wp_ajax_update_sms_consent_status', 'update_sms_consent_status');

function check_sms_consent_status()
{
    $get_sms_consent_status = get_option('sms_consent_status');
    if ($get_sms_consent_status == 0 || !isset($get_sms_consent_status)) {
        return false;
    } else {
        return true;
    }
}

function update_sms_consent_template()
{
    global $wpdb;
    $sms_consent_template_table = $wpdb->prefix . 'modulus_sms_consent_template';

    $title = 'SMS consent template for checkout';
    $text = $_POST['consent_template'];
    $language = defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : 'el';

    $existing_row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $sms_consent_template_table WHERE language = %s", $language));

    if ($existing_row) {

        $wpdb->update(
            $sms_consent_template_table,
            array(
                'title' => $title,
                'text' => $text,
                'last_edit_date' => current_time('mysql')
            ),
            array('id' => $existing_row->id)
        );
    } else {

        $wpdb->insert(
            $sms_consent_template_table,
            array(
                'title' => $title,
                'text' => $text,
                'language' => $language
            ),
            array('%s', '%s', '%s')
        );
    }

}
function fetch_sms_consent_template()
{
    global $wpdb;
    $sms_consent_template_table = $wpdb->prefix . 'modulus_sms_consent_template';
    $fetch_sms_consent_template = $wpdb->get_var("SELECT text FROM $sms_consent_template_table");
    return $fetch_sms_consent_template;
}
function consent_tab_contents()
{
    if (isset($_POST['update_sms_consent_template']) && $_POST['update_sms_consent_template']) {
        update_sms_consent_template();
    }
    ?>
    <style>
        #insert-media-button {
            display: none !important;
        }
    </style>

    <label for="activate_consent">
        <input type="checkbox" id="activate_consent" name="activate_consent" <?php if (check_sms_consent_status() == true) {
            echo 'checked';
        } ?>>
        Ενεργοποίηση συναίνεσης για λήψη SMS
    </label>

    <script>
        jQuery(document).ready(function ($) {
            $('#activate_consent').change(function () {
                var consent_status = this.checked ? 1 : 0;

                $.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    type: 'POST',
                    data: {
                        action: 'update_sms_consent_status',

                        consent_status: consent_status
                    },
                    success: function (response) {
                        console.log(response.data);
                        window.location.reload();
                    },
                    error: function (errorThrown) {
                        console.log(errorThrown);
                    }
                });
            });
        });

    </script>
    <form method="post" action="">
        <?php
        if (check_sms_consent_status() == true) {
            wp_editor(
                fetch_sms_consent_template(),
                'consent_template'
            );

            ?>
            <input type="submit" id="update_sms_consent_template" name="update_sms_consent_template" class="btn btn-dark"
                value="Αποθήκευση">
        </form>
        <?php
        }
}

// Register settings function
//fields for the settings tabs
function woo_sms_alerts_settings_init()
{
    register_setting('woo_sms_alerts_settings', 'woo_sms_alerts_settings');

    add_settings_section(
        'woo_sms_alerts_general_settings_section',
        __('', 'woo-sms-alerts'),
        'woo_sms_alerts_general_settings_section_callback', // added a callback function
        'woo-sms-alerts-settings'
    );

    add_settings_field(
        'woo_sms_alerts_api_url',
        __('Api Url', 'woo-sms-alerts'),
        'woo_sms_alerts_api_url_callback',
        'woo-sms-alerts-settings',
        'woo_sms_alerts_general_settings_section'
    );

    add_settings_field(
        'woo_sms_alerts_routing_option',
        __('Routing Option', 'woo-sms-alerts'),
        'woo_sms_alerts_routing_option_callback',
        'woo-sms-alerts-settings',
        'woo_sms_alerts_general_settings_section'
    );

    add_settings_field(
        'woo_sms_alerts_api_token',
        __('API Token', 'woo-sms-alerts'),
        'woo_sms_alerts_api_token_callback',
        'woo-sms-alerts-settings',
        'woo_sms_alerts_general_settings_section'
    );

    add_settings_field(
        'woo_sms_alerts_sender',
        __('Sender ID', 'woo-sms-alerts'),
        'woo_sms_alerts_sender_callback',
        'woo-sms-alerts-settings',
        'woo_sms_alerts_general_settings_section'
    );

    add_settings_field(
        'woo_sms_alerts_back_in_stock',
        __(' Back in Stock', 'woo-sms-alerts'),
        'woo_sms_alerts_back_in_stock_callback',
        'woo-sms-alerts-settings',
        'woo_sms_alerts_general_settings_section'
    );

    add_settings_field(
        'woo_sms_alerts_back_in_stock_template',
        __(' Back in Stock Template', 'woo-sms-alerts'),
        'woo_sms_alerts_back_in_stock_template_callback',
        'woo-sms-alerts-settings',
        'woo_sms_alerts_general_settings_section'
    );
}
function woo_sms_alerts_general_settings_section_callback()
{

}
function woo_sms_alerts_back_in_stock_callback()
{
    $options = get_option('woo_sms_alerts_settings');
    $checked = isset($options['woo_sms_alerts_back_in_stock']) ? $options['woo_sms_alerts_back_in_stock'] : 0;
    echo '<input type="checkbox" id="woo_sms_alerts_back_in_stock" name="woo_sms_alerts_settings[woo_sms_alerts_back_in_stock]" value="1" ' . checked(1, $checked, false) . ' />';
}
function woo_sms_alerts_back_in_stock_template_callback()
{
    $options = get_option('woo_sms_alerts_settings');

    $woo_sms_alerts_back_in_stock_template = isset($options['woo_sms_alerts_back_in_stock_template']) ? $options['woo_sms_alerts_back_in_stock_template'] : 0;
    echo '<div> <div class="row padded-message" style="margin-bottom: 1em;max-width: 400px;">
    <h6>Οδηγίες για γραφή πρότυπου μηνύματος back in stock:</h6>
    <span>Για το όνομα του προϊόντος:<strong>{product_name}</strong>, για το link του προϊόντος: <strong>{product_url}</strong></span>

</div>
    <textarea rows="10" style="width:100%!important;margin-top:1em;" id="back_in_stock_template" name="woo_sms_alerts_settings[woo_sms_alerts_back_in_stock_template]" value="' . $woo_sms_alerts_back_in_stock_template . '">' . esc_textarea($woo_sms_alerts_back_in_stock_template) . '</textarea>
   

    </div>';
}
//fields for the send test sms tab

function woo_sms_alerts_test_sms_settings_init()
{
    register_setting('woo_sms_alerts_test_sms_settings', 'woo_sms_alerts_test_sms_settings');

    add_settings_section(
        'woo_sms_alerts_test_sms_settings_section',
        __('', 'woo-sms-alerts'),
        null,
        'woo-sms-alerts-test-sms-settings'
    );

    add_settings_field(
        'woo_sms_alerts_phone_number',
        __('Τηλέφωνο', 'woo-sms-alerts'),
        'woo_sms_alerts_phone_number_callback',
        'woo-sms-alerts-test-sms-settings',
        'woo_sms_alerts_test_sms_settings_section'
    );

    add_settings_field(
        'woo_sms_alerts_sms_message',
        __('Μήνυμα', 'woo-sms-alerts'),
        'woo_sms_alerts_sms_message_callback',
        'woo-sms-alerts-test-sms-settings',
        'woo_sms_alerts_test_sms_settings_section'
    );
}

//sends test sms from settings page

function send_sms_test_callback()
{
    if (isset($_POST['phoneNumber']) && isset($_POST['message'])) {

        $phoneNumber = sanitize_text_field($_POST['phoneNumber']);
        $smsMessage = sanitize_text_field($_POST['message']);

        $modulus_settings = woo_sms_alerts_get_sender_settings();

        if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
            $phoneNumber = '30' . $phoneNumber;
        }

        $sender_id = $modulus_settings->sender;
        $api_url_info = $modulus_settings->api_url;
        $routing_info = $modulus_settings->routing_option;
        $api_token = $modulus_settings->api_token;

        // echo '<script> console.log('.$phoneNumber.')</script>';


        if ($routing_info == 'sms') {
            // Prepare SMS data
            $smsData = array(
                'priority' => 3,
                'recipients' => array(
                    array(
                        'msisdn' => $phoneNumber
                    )
                ),
                'sms' => array(
                    'sender' => $sender_id,
                    'text' => $smsMessage,
                    'encoding' => 'gsm',
                    'validityPeriod' => 86400
                ),
                'dlr' => true,
                'dlrUrl' => 'https://test.gr/callbackmessage',
                'externalTags' => array('string')

            );

        } else if ($routing_info == 'viber') {

            $smsData = array(
                'routing' => 'viber_AmdTelecom_Trans',
                'priority' => 3,
                'recipients' => array(
                    array(
                        'msisdn' => $phoneNumber,
                    )
                ),
                'viber' => array(
                    'sender' => $sender_id,
                    'type' => 'text',
                    'text' => $smsMessage,
                    'encoding' => 'gsm',
                    'validityPeriod' => 86400
                ),
                'dlr' => true,
                'dlrUrl' => 'https://test.gr/callbackmessage',
                'externalTags' => array('string')
            );

        } else if ($routing_info == 'viber2sms') {



            $smsData = array(
                'routing' => 'viber_AmdTelecom_Trans_SMS',
                'priority' => 3,
                'recipients' => array(
                    array(
                        'msisdn' => $phoneNumber,
                    )

                ),
                'viber' => array(
                    'sender' => $sender_id,
                    'type' => 'text',
                    'text' => $smsMessage,
                    'encoding' => 'gsm',
                    'validityPeriod' => 86400
                ),
                'sms' => array(
                    'sender' => $sender_id,
                    'text' => $smsMessage,
                    'encoding' => 'gsm',
                    'validityPeriod' => 86400
                ),
                'dlr' => true,
                'dlrUrl' => 'https://test.gr/callbackmessage',
                'externalTags' => array('string')
            );

        }

        // Convert SMS data to JSON
        $jsonData = json_encode($smsData);

        // echo '<script>console.log(' . $jsonData . ')</script>';

        // cURL request to send SMS
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url_info);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $api_token
            )
        );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        $response = json_decode($response, true);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $message = $response['messages'][0]['status']['message'];
        curl_close($ch);

        if ($httpcode == 200) {
            wp_send_json_success(array('message' => $message, 'httpcode' => $httpcode));
        }else {
            $message = $response['message'];
            wp_send_json_success(array('message' => $message, 'httpcode' => $httpcode));
        }
        // echo json_encode(array('success' => true, 'response' => $response, 'httpcode' => $httpcode));
    } else {
        echo json_encode(array('error' => 'Invalid data'));
    }

    wp_die();

}


add_action('wp_ajax_modulus_send_test_sms', 'send_sms_test_callback');

function woo_sms_alerts_api_url_callback()
{
    $options = get_option('woo_sms_alerts_settings');
    $value = isset($options['api_url']) ? $options['api_url'] : '';
    echo '<input type="text" class="form-control modulus-input"  name="woo_sms_alerts_settings[api_url]" value="' . esc_attr($value) . '" />';



}

// Callbacks for the settings fields
function woo_sms_alerts_routing_option_callback()
{
    $options = get_option('woo_sms_alerts_settings');
    $value = isset($options['routing_option']) ? $options['routing_option'] : '';
    ?>
    <select name="woo_sms_alerts_settings[routing_option]">
        <option value="sms" <?php selected($value, 'sms'); ?>>SMS</option>
        <option value="viber" <?php selected($value, 'viber'); ?>>Viber</option>
        <option value="viber2sms" <?php selected($value, 'viber2sms'); ?>>Viber2SMS</option>
    </select>

    <?php
}

function woo_sms_alerts_api_token_callback()
{
    $options = get_option('woo_sms_alerts_settings');
    $value = isset($options['api_token']) ? $options['api_token'] : '';
    echo '<input type="text" class="form-control modulus-input" name="woo_sms_alerts_settings[api_token]" value="' . esc_attr($value) . '" />';
}

function woo_sms_alerts_sender_callback()
{
    $options = get_option('woo_sms_alerts_settings');
    $value = isset($options['sender']) ? $options['sender'] : '';
    echo '<input type="text" class="form-control modulus-input" name="woo_sms_alerts_settings[sender]" value="' . esc_attr($value) . '" />';
}

function woo_sms_alerts_phone_number_callback()
{

    echo '<input type="tel" id="modulus_sms_test_phone" class="regular-text modulus-input" name="test_sms_phone" value="" />  <p class="hint-text">Η μορφή του τηλεφώνου για Ελλάδα είναι 3069ΧΧΧΧΧΧΧΧ</p>';
}

function woo_sms_alerts_sms_message_callback()
{

    echo '<textarea id="modulus_sms_test_message" name="test_sms_message" rows="10" cols="57" required></textarea>';
}

function add_woo_sms_settings_menu()
{
    add_menu_page('SMS Settings', 'SMS Settings', 'manage_options', 'woo-sms-settings', 'woo_sms_alerts_settings_page');
}

function woo_sms_alerts_send_test_sms_button_callback()
{
    ?>
    <div class="modulus_test_msg_response   custom-button-primary"></div>
    <button type="button" id="modulus_test_sms" class="button-primary">
        <?php _e('Send Test SMS', 'woo-sms-alerts'); ?>
    </button>
    <?php
}

function toggle_sms_sent()
{
    global $wpdb;

    $order_id = intval($_POST['order_id']);
    $setStatus = sanitize_text_field($_POST['setStatus']);


    $table_name_orders = $wpdb->prefix . 'modulus_woo_orders_board';


    $updated = $wpdb->update(
        $table_name_orders,
        array('sms_sent' => $setStatus),
        array('id' => $order_id),
        array('%d'),
        array('%d')
    );

    if ($updated !== false) {
        wp_send_json_success();
    } else {
        wp_send_json_error();
    }
}

function save_selected_template()
{
    global $wpdb;

    $order_id = intval($_POST['order_id']);
    $template_id = intval($_POST['template_id']);


    $table_name_orders = $wpdb->prefix . 'modulus_woo_orders_board';


    $updated = $wpdb->update(
        $table_name_orders,
        array('order_template' => $template_id),
        array('id' => $order_id),
        array('%d'),
        array('%d')
    );

    if ($updated !== false) {
        wp_send_json_success();
        wp_send_json_error();
    }
}

/// TIME CONSTRAINTS CONTENT FUNCTION ////

function check_if_constraints_is_enabled()
{
    global $wpdb;
    $table_name_sms_constraints_settings = $wpdb->prefix . 'modulus_sms_constraints_settings';

    $get_res = $wpdb->get_results("SELECT * FROM $table_name_sms_constraints_settings");
    $status = $wpdb->get_var("SELECT status FROM $table_name_sms_constraints_settings");
    if ($get_res && $status == 1) {
        return true;
    } else {
        return false;
    }
}
function time_constraints_admin_content()
{
    // if(fetch_constraints() ==='true'){
    //     echo 'ΜΠΟΡΕΙΣ ΝΑ ΣΤΕΙΛΕΙΣ<br>';
    // }else {
    //     echo 'δεν ΜΠΟΡΕΙΣ ΝΑ ΣΤΕΙΛΕΙΣ<br>';

    // }
    ob_start();
    ?>
    <script>
        function save_modulus_sms_constraints() {
            var time_from = jQuery("#time_from").val();

            var time_to = jQuery("#time_to").val();

            var days = [];
            jQuery('input[name="day[]"]:checked').each(function () {
                // Do something with the checked checkbox
                // console.log("Checkbox with value " + $(this).val() + " is checked.");
                days.push(jQuery(this).val())
            });
            var checkbox = jQuery('#constraints_status');
            if (checkbox.is(':checked')) {
                status = 1;
            } else {
                status = 0;
            }
            // console.log(jQuery('#constraints_status').val());

            var timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;

            jQuery.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                method: 'POST',
                data: {
                    action: 'save_constraints_ajax_callback',
                    status: status,
                    time_from: time_from,
                    time_to: time_to,
                    time_zone: timeZone,
                    days: days
                },
                success: function (response) {
                    // Handle success response if needed
                    console.log(response);
                    // alert('Message sent!');
                    window.location.reload();
                    // $('#modulus_sms_test_message').val('');
                    // $('#modulus_sms_test_phone').val('');

                },
                error: function (error) {
                    // Handle error response if needed
                    console.error(error);
                }
            });
        }  
    </script>


    <?php
    if (check_if_constraints_is_enabled() == false) {

        ?>
        <label>
            <input type="checkbox" name="constraints_status" id="constraints_status" onchange="save_modulus_sms_constraints()">
            Ενεργοποίηση χρονοπεριορισμού
        </label>
    <?php } else { ?>
        <label>
            <input type="checkbox" name="constraints_status" id="constraints_status" onchange="save_modulus_sms_constraints()"
                checked>
            Ενεργοποίηση χρονοπεριορισμού
        </label>
        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row">
                        Επιτρεπόμενη ώρα από:
                    </th>
                    <td>

                        <input type="time" id="time_from" class="form-control" name="time_from"
                            value="<?php echo fetch_constraint_time_ranges('time_from'); ?>">

                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        Επιτρεπόμενη ώρα εώς:
                    </th>
                    <td>
                        <input type="time" class="form-control" id="time_to" name="time_to"
                            value="<?php echo fetch_constraint_time_ranges('time_to'); ?>">
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        Επιτρεπόμενες ημέρες:
                    </th>
                    <td>

                        <input type="checkbox" name="day[]" value="Monday" class="btn-check" id="monday" <?php echo get_days_checkboxes('Monday'); ?>>
                        <label for="monday" class="btn btn-outline-success">Δευτέρα</label>
                        <input type="checkbox" class="btn-check" id="tuesday" name="day[]" value="Tuesday" <?php echo get_days_checkboxes('Tuesday'); ?>>
                        <label for="tuesday" class="btn btn-outline-success">Τρίτη</label>
                        <input type="checkbox" class="btn-check" name="day[]" value="Wednesday" id="wed" <?php echo get_days_checkboxes('Wednesday'); ?>>
                        <label for="wed" class="btn btn-outline-success">Τετάρτη</label>
                        <input type="checkbox" class="btn-check" name="day[]" value="Thursday" id="thurs" <?php echo get_days_checkboxes('Thursday'); ?>>
                        <label for="thurs" class="btn btn-outline-success">Πέμπτη</label>
                        <input type="checkbox" class="btn-check" name="day[]" value="Friday" id="fri" <?php echo get_days_checkboxes('Friday'); ?>>
                        <label for="fri" class="btn btn-outline-success">Παρασκευή</label>
                        <input type="checkbox" class="btn-check" name="day[]" value="Saturday" id="sat" <?php echo get_days_checkboxes('Saturday'); ?>>
                        <label for="sat" class="btn btn-outline-success">Σαββάτο</label>
                        <input type="checkbox" class="btn-check" name="day[]" value="Sunday" id="sunday" <?php echo get_days_checkboxes('Sunday'); ?>>
                        <label for="sunday" class="btn btn-outline-success">Κυριακή</label>

                    </td>
                </tr>
            </tbody>
        </table>

        <p class="submit"><button type="submit" name="submit" id="submit" class="btn btn-dark"
                onclick="save_modulus_sms_constraints()">Αποθήκευση</button></p>
        <?php

    }
    echo ob_get_clean();
}
// Register settings function
//fields for the settings tabs
function save_constraints_ajax_callback()
{
    $time_from = $_POST['time_from'];
    $time_to = $_POST['time_to'];
    $day = $_POST['days'];
    $days = array();
    global $wpdb;
    $days_array = array();
    $status = $_POST['status'];
    $time_zone = $_POST['time_zone'];
    $table_name_sms_constraints_settings = $wpdb->prefix . 'modulus_sms_constraints_settings';
    $get_table = $wpdb->get_var("SELECT id FROM $table_name_sms_constraints_settings");

    if ($get_table) {
        // Loop through each day and add it to the days array with the key 'day'
        foreach ($day as $d) {
            $days_array[] = array('day' => $d);
        }

        $get_table_contents = $wpdb->get_var("SELECT constraints FROM $table_name_sms_constraints_settings");
        $data_to_store = array(
            'days' => $days_array,
            'time_from' => $time_from,
            'time_to' => $time_to,
            'time_zone' => $time_zone,
        );
        $data = array(
            'status' => $status,
            'constraints' => json_encode($data_to_store),
            'modified_date' => current_time('mysql', 1),
        );
        $where = array(
            'id' => $get_table,
        );
        $wpdb->update($table_name_sms_constraints_settings, $data, $where);

        wp_send_json_success($data);
    } else {

        $data = array(
            'status' => $status,
            'constraints' => null,
            'created_date' => current_time('mysql', 1),
            'modified_date' => current_time('mysql', 1),
        );

        $wpdb->insert($table_name_sms_constraints_settings, $data);
        wp_send_json_success($data);
    }

}

add_action('wp_ajax_save_constraints_ajax_callback', 'save_constraints_ajax_callback');
add_action('wp_ajax_save_selected_template', 'save_selected_template');
add_action('wp_ajax_toggle_sms_sent', 'toggle_sms_sent');
add_action('admin_init', 'woo_sms_alerts_settings_init', 10);
add_action('admin_menu', 'add_woo_sms_settings_menu', 10);
add_action('admin_menu', 'woo_sms_alerts_test_sms_settings_init', 10);

