<?php

function display_back_in_stock_notification_link()
{

    global $product;
    $product_id = $product->get_id();
    $manage_stock = get_post_meta($product_id, '_manage_stock', true);

    $stock_status = 0;


    if ($manage_stock === 'yes') {
        $stock_status = $product->get_stock_quantity();
    } else {
        $get_stock_status = get_post_meta($product_id, '_stock_status', true);
        if ($get_stock_status === 'instock') {
            $stock_status = 1;
        }

    }


    $options = get_option('woo_sms_alerts_settings');
    $back_in_stock_activated = isset($options['woo_sms_alerts_back_in_stock']) && $options['woo_sms_alerts_back_in_stock'] == 1;

    if ($back_in_stock_activated && ($stock_status == 0)) {

        echo '<a href="#" class="back-in-stock-notification-link" productId="' . $product_id . '" baseApi="' . admin_url('admin-ajax.php') . '" style="display: block; margin-top: 9px;">' . __('Ειδοποιήστε με όταν το προϊόν έχει απόθεμα', 'woocommerce') . '</a>';
        echo '<div class="back-in-stock-form" style="display:none;">';
        echo '<div style="position: relative;">';
        echo '<input type="text" id="phone-number" class="form-control" placeholder="' . __('Εισάγετε τον αριθμό σας', 'woocommerce') . '" style="width: 100%; margin-top: 10px" />';
        echo '<span class="hint-text" style="color: #888; font-size: 12px;">' . __('Ο αριθμός πρέπει να είναι της μορφής 3069XXXXXXXX', 'woocommerce') . '</span>';
        echo '<button id="save-notification" class="btn btn-dark" style="position: absolute; right: 0; top: 0;font-size:15px;">' . __('Αποστολή', 'woocommerce') . '</button>';
        echo '</div>';
        echo '</div>';
    }
}

add_action('woocommerce_single_product_summary', 'display_back_in_stock_notification_link', 35);


add_action('wp_enqueue_scripts', 'enqueue_ajax_script');

function enqueue_ajax_script()
{
    wp_localize_script('ajax-script', 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
}

add_action('wp_ajax_nopriv_save_back_in_stock_notification', 'save_back_in_stock_notification');
add_action('wp_ajax_save_back_in_stock_notification', 'save_back_in_stock_notification');

function save_back_in_stock_notification()
{
    global $wpdb;
    $table_name_back_in_stock = $wpdb->prefix . 'modulus_woo_back_in_stock';

    $product_id = sanitize_text_field($_POST['product_id']);
    $phone_number = sanitize_text_field($_POST['phone_number']);

    if (substr($phone_number, 0, 3) !== '+30' && substr($phone_number, 0, 2) !== '30') {
        $phone_number = '30' . $phone_number;
    }


    $wpdb->insert(
        $table_name_back_in_stock,
        array(
            'product_id' => $product_id,
            'phone_number' => $phone_number,
        )
    );


    echo 'success';
    wp_die();
}

function check_product_stock_status($product_id)
{
    global $wpdb;
    $table_name_back_in_stock = $wpdb->prefix . 'modulus_woo_back_in_stock';

    $rows = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name_back_in_stock WHERE product_id = %d AND notify_id = %d", $product_id, 0));
    $product = wc_get_product($product_id);
    $prod_url = get_permalink($product_id);
    if ($rows) {

        foreach ($rows as $product_exists) {

            $phone_number = $product_exists->phone_number;
            $options = get_option('woo_sms_alerts_settings');
            $woo_sms_alerts_back_in_stock_template = $options['woo_sms_alerts_back_in_stock_template'];

            if ($product) {
                $product_name = $product->get_name();
                $placeholders = array("{product_name}", "{product_url}");

                $values = array($product_name, $prod_url);

                $smsreplace = str_replace($placeholders, $values, $woo_sms_alerts_back_in_stock_template);

                $message = $smsreplace;//"Γεια σας, το προϊόν: \"$product_name\" για το οποίο ενδιαφέρεστε έχει πλέον απόθεμα θα το βρείτε το παρακάτω link: " . $prod_url;
            } else {
                $message = "Γεια σας, το προϊόν για το οποίο ενδιαφέρεστε έχει πλέον απόθεμα.";
            }


            back_in_stock_sms_callback($phone_number, $message);


            $wpdb->query(
                $wpdb->prepare(
                    "UPDATE $table_name_back_in_stock 
                    SET notify_id = %d 
                    WHERE product_id = %d AND phone_number = %s",
                    1,
                    $product_id,
                    $phone_number
                )
            );

            /*
            $wpdb->update(
                $table_name_back_in_stock,
                array('notify_id' => 1),
                array('product_id' => $product_id),
                array('%d'),
                array('%d')
            );
            */
        }

    }
}

//add_action('save_post', 'check_product_stock_change', 10, 3);

add_action('wp_insert_post', 'check_product_stock_change', 10, 3);

function check_product_stock_change($product_id)
{

    $manage_stock = get_post_meta($product_id, '_manage_stock', true);


    if ($manage_stock === 'yes') {

        $new_stock_quantity = get_post_meta($product_id, '_stock', true);

        if ($new_stock_quantity > 0) {
            check_product_stock_status($product_id);
        }

    } else {

        $new_stock_status = get_post_meta($product_id, '_stock_status', true);

        if ($new_stock_status === 'instock') {
            check_product_stock_status($product_id);
        }
    }


}

add_action('save_post_product', 'check_product_stock_change');

function back_in_stock_sms_callback($phone_number, $message)
{


    $phone_number = sanitize_text_field($phone_number);
    $message = sanitize_text_field($message);

    $modulus_settings = woo_sms_alerts_get_sender_settings();


    $sender_id = $modulus_settings->sender;
    $api_url_info = $modulus_settings->api_url;
    $routing_info = $modulus_settings->routing_option;
    $api_token = $modulus_settings->api_token;


    if ($routing_info == 'sms') {
        $smsData = array(
            'priority' => 3,
            'recipients' => array(
                array(
                    'msisdn' => $phone_number
                )
            ),
            'sms' => array(
                'sender' => $sender_id,
                'text' => $message,
                'encoding' => 'gsm',
                'validityPeriod' => 86400
            ),
            'dlr' => false,
            'dlrUrl' => '',
            'externalTags' => array('string')
        );
    } else if ($routing_info == 'viber') {


        $smsData = array(
            'routing' => 'viber_AmdTelecom_Trans',
            'priority' => 3,
            'recipients' => array(
                array(
                    'msisdn' => $phone_number,
                )
            ),
            'viber' => array(
                'sender' => $sender_id,
                'type' => 'text',
                'text' => $message,
                'encoding' => 'gsm',
                'validityPeriod' => 86400
            ),
            'dlr' => true,
            'dlrUrl' => 'https://test.gr/callbackmessage',
            'externalTags' => array('string')
        );

    } else if ($routing_info == 'viber2sms') {


        $smsData = array(
            'routing' => 'viber_AmdTelecom_Trans_SMS',
            'priority' => 3,
            'recipients' => array(
                array(
                    'msisdn' => $phone_number,
                )

            ),
            'viber' => array(
                'sender' => $sender_id,
                'type' => 'text',
                'text' => $message,
                'encoding' => 'gsm',
                'validityPeriod' => 86400
            ),
            'sms' => array(
                'sender' => $sender_id,
                'text' => $message,
                'encoding' => 'gsm',
                'validityPeriod' => 86400
            ),
            'dlr' => true,
            'dlrUrl' => 'https://test.gr/callbackmessage',
            'externalTags' => array('string')
        );

    }


    $jsonData = json_encode($smsData);


    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url_info);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $api_token
        )
    );
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);


    return true;

}


add_action('wp_ajax_modulus_back_in_stock_sms', 'back_in_stock_sms_callback');
