<?php

function fetch_constraints()
{
    global $wpdb;
    $table_name_sms_constraints_settings = $wpdb->prefix . 'modulus_sms_constraints_settings';

    $get_res = $wpdb->get_results("SELECT * FROM $table_name_sms_constraints_settings");

    foreach ($get_res as $row) {
        $json_data = $row->constraints;
        $decoded_data = json_decode($json_data, true);

        // Check if JSON decoding was successful and 'days' key exists and is an array
        if ($decoded_data !== null && isset($decoded_data['days']) && is_array($decoded_data['days'])) {
            $days_array = array();
            foreach ($decoded_data['days'] as $d) {
                if (isset($d['day'])) { // Check if 'day' key exists in each item
                    array_push($days_array, $d['day']);
                }
            }

            $time_from_timestamp = !empty($decoded_data['time_from']) ? strtotime($decoded_data['time_from']) : false;
            $time_to_timestamp = !empty($decoded_data['time_to']) ? strtotime($decoded_data['time_to']) : false;

            // Check if 'time_zone' exists and is valid, or set a default
            $time_zone = isset($decoded_data['time_zone']) ? $decoded_data['time_zone'] : '';
            if (empty($time_zone) || !in_array($time_zone, DateTimeZone::listIdentifiers())) {
                echo "Using default timezone: UTC"; // Optional: inform the user
                $time_zone = 'UTC'; // Set default timezone
            }

            try {
                $date = new DateTime("now", new DateTimeZone($time_zone));
                echo $date->format('Y-m-d H:i:s'); // Output the date
            } catch (Exception $e) {
                echo "Error creating DateTime: " . $e->getMessage(); // Handle any exceptions
            }

            $current_time = strtotime($date->format('H:i'));
            $current_day = $date->format('l');

            if ($row->status == 1) {
                if (!empty($days_array)) {
                    if (in_array($current_day, $days_array)) {
                        if ($time_from_timestamp !== false && $time_to_timestamp !== false) {
                            if ($current_time >= $time_from_timestamp && $current_time <= $time_to_timestamp) {
                                return 'true';
                            } else {
                                return 'false';
                            }
                        }
                    } else {
                        return 'false';
                    }
                } else {
                    return 'true';
                }
            } else {
                return 'true';
            }
        } else {
            echo "Invalid or empty constraints data"; // Optional: inform the user
            return 'false';
        }
    }
}


//function fetch_constraints()
//{
//    global $wpdb;
//    $table_name_sms_constraints_settings = $wpdb->prefix . 'modulus_sms_constraints_settings';
//
//    $get_res = $wpdb->get_results("SELECT * FROM $table_name_sms_constraints_settings");
//
//    foreach ($get_res as $row) {
//
//        $json_data = $row->constraints;
//        $decoded_data = json_decode($json_data, true);
//
//        $day = $decoded_data['days'];
//        $days_array = array();
//        foreach ($day as $d) {
//            array_push($days_array, $d['day']);
//        }
//
//        $time_from_timestamp = strtotime($decoded_data['time_from']);
//        $time_to_timestamp = strtotime($decoded_data['time_to']);
////        $time_zone = $decoded_data['time_zone'];
////        $date = new DateTime("now", new DateTimeZone($time_zone));
//        // Check if the timezone is valid or set a default
//        $time_zone = isset($decoded_data['time_zone']) ? $decoded_data['time_zone'] : '';
//        if (empty($time_zone) || !in_array($time_zone, DateTimeZone::listIdentifiers())) {
//            echo "Using default timezone: UTC"; // Optional: inform the user
//            $time_zone = 'UTC'; // Set default timezone
//        }
//
//        try {
//            $date = new DateTime("now", new DateTimeZone($time_zone));
//            echo $date->format('Y-m-d H:i:s'); // Output the date
//        } catch (Exception $e) {
//            echo "Error creating DateTime: " . $e->getMessage(); // Handle any exceptions
//        }
//        $current_time = strtotime($date->format('H:i'));
//        $current_day = $date->format('l');
//
//
//        if ($row->status == 1) {
//            if (!empty($days_array)) {
//                if (in_array($current_day, $days_array)) {
//                    if (!empty($time_from_timestamp) || !empty($time_to_timestamp)) {
//
//                        if ($current_time >= $time_from_timestamp && $current_time <= $time_to_timestamp) {
//                            return 'true';
//                        } else {
//                            return 'false';
//                        }
//                    }
//                } else {
//                    return 'false';
//                }
//            } else {
//                return 'true';
//            }
//
//        } else {
//            return 'true';
//        }
//
//        /* if ($row->status == 1) {
//             if (in_array($current_day, $days_array)) {
//                 if (!empty($time_from_timestamp) || !empty($time_to_timestamp)) {
//
//                     if ($current_time >= $time_from_timestamp && $current_time <= $time_to_timestamp) {
//                         return 'true';
//                     } else {
//                         return 'false';
//                     }
//                 }
//             } else {
//                 return 'false';
//             }
//         } else {
//             return 'true';
//         }*/
//    }
//
//}


//function get_days_checkboxes($day_)
//{
//    global $wpdb;
//    $table_name_sms_constraints_settings = $wpdb->prefix . 'modulus_sms_constraints_settings';
//
//    $get_res = $wpdb->get_results("SELECT * FROM $table_name_sms_constraints_settings");
//
//    foreach ($get_res as $row) {
//
//        $json_data = $row->constraints;
//        $decoded_data = json_decode($json_data, true);
//        $day = $decoded_data['days'];
//        $days_array = array();
//        foreach ($day as $d) {
//            array_push($days_array, $d['day']);
//        }
//
//        if (in_array($day_, $days_array)) {
//            echo 'checked';
//        }
//
//    }
//}
function get_days_checkboxes($day_)
{
    global $wpdb;
    $table_name_sms_constraints_settings = $wpdb->prefix . 'modulus_sms_constraints_settings';

    $get_res = $wpdb->get_results("SELECT * FROM $table_name_sms_constraints_settings");

    foreach ($get_res as $row) {
        $json_data = $row->constraints;

        // Check if $json_data is not empty or null before decoding
        if (!empty($json_data) && is_string($json_data)) {
            $decoded_data = json_decode($json_data, true);

            // Check if decoding was successful and 'days' key exists and is an array
            if ($decoded_data !== null && json_last_error() === JSON_ERROR_NONE) {
                if (isset($decoded_data['days']) && is_array($decoded_data['days'])) {
                    $days_array = array();

                    foreach ($decoded_data['days'] as $d) {
                        if (isset($d['day'])) { // Check if 'day' key exists in each item
                            $days_array[] = $d['day'];
                        }
                    }

                    // Check if the provided day is in the days array
                    if (in_array($day_, $days_array)) {
                        echo 'checked';
                    }
                }
            } else {
                // Log error if JSON decoding fails
                error_log('JSON decoding failed: ' . json_last_error_msg());
            }
        } else {
            // Log if $json_data is empty or not a string
            error_log('Invalid or empty JSON data.');
        }
    }
}


function sms_instructions_text()
{
    echo '<h5>Οδηγίες σύνταξης SMS:</h5>';
}

function send_sms_heading()
{
    echo '<h3>Αποστολή SMS</h3>';
}

function close_modal_btn()
{
    ?>
    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Ακύρωση</button>
    <?php

}

function instructions_sms_list($type)
{
    if ($type == "order") {
        ?>

        <p>Για λόγους ευκολίας μπορείτε να χρησιμοποιείστε τις παρακάτω μεταβλητές για γρήγορη αντικατάσταση των
            δεδομένων::</p>
        <ol>
            <li>όνομα πελάτη => {first_name}</li>
            <li>επώνυμο πελάτη => {last_name}</li>
            <li>αριθμός παραγγελίας => {order_id}</li>
            <li>σύνολο της παραγγελίας => {order_total}</li>
        </ol>
        <?php
    } else {
        ?>
        <p>Για λόγους ευκολίας μπορείτε να χρησιμοποιείστε τις παρακάτω μεταβλητές για γρήγορη αντικατάσταση των
            δεδομένων::</p>
        <ol>
            <li>όνομα πελάτη => {first_name}</li>
            <li>επώνυμο πελάτη => {last_name}</li>
        </ol>

        <?php
    }
}

function fetch_constraint_time_ranges($value)
{
    global $wpdb;
    $table_name_sms_constraints_settings = $wpdb->prefix . 'modulus_sms_constraints_settings';

    $get_res = $wpdb->get_results("SELECT * FROM $table_name_sms_constraints_settings");

    foreach ($get_res as $row) {

        $json_data = $row->constraints;
        $decoded_data = json_decode($json_data, true);

        if (!empty($decoded_data[$value])) {
            echo $decoded_data[$value];
        } else {
            echo '';
        }

    }
}

function woo_sms_alerts_update_custom_table($old_value, $new_value)
{
    global $wpdb;
    $table_name = $wpdb->prefix . 'woo_sms_alerts_settings';

    $data = array(
        'api_url' => $new_value['api_url'],
        'routing_option' => $new_value['routing_option'],
        'api_token' => $new_value['api_token'],
        'sender' => $new_value['sender']
    );


    $data_format = array('%s', '%s', '%s', '%s');

    $existing = $wpdb->get_row("SELECT * FROM $table_name WHERE id = 1");

    $table_name_template_back_instock = $wpdb->prefix . 'modulus_woo_sms_backinstock_template';


    $existing_template = $wpdb->get_row("SELECT * FROM $table_name_template_back_instock WHERE id = 1");
    $language = defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : 'el';

    if ($existing_template) {

        $wpdb->update(
            $existing_template,
            array(
                'title' => "Backinstock",
                'message' => $new_value['woo_sms_alerts_back_in_stock_template'],
                'last_edit_date' => current_time('mysql', 1)
            ),
            array('id' => 1),
            array('%s', '%s', '%s'),
            array('%d')
        );

    } else {

        $data_ = array(
            'title' => "Backinstock",
            'message' => $new_value['woo_sms_alerts_back_in_stock_template'],
            'language' => $language
        );


        $data_format_ = array(
            '%s',
            '%s',
            '%s'
        );

        $result_ = $wpdb->insert($existing_template, $data_, $data_format_);

    }

    if ($existing) {

        $result = $wpdb->update($table_name, $data, array('id' => 1), $data_format);
    } else {

        $result = $wpdb->insert($table_name, $data, $data_format);
    }

    if ($result === false) {
        error_log("Error interacting with the table. Last query: " . $wpdb->last_query);
    } else {
        error_log("Successfully updated/inserted into the custom table.");
    }
}

add_action('update_option_woo_sms_alerts_settings', 'woo_sms_alerts_update_custom_table', 10, 2);


// Fetch Sender ID from our custom table
function woo_sms_alerts_get_sender_id()
{
    global $wpdb;
    $table_name = $wpdb->prefix . 'woo_sms_alerts_settings';
    $row = $wpdb->get_row("SELECT sender FROM $table_name");

    return $row->sender;
}


// Fetch Settings from our custom table
function woo_sms_alerts_get_sender_settings()
{
    global $wpdb;
    $table_name = $wpdb->prefix . 'woo_sms_alerts_settings';
    $row = $wpdb->get_row("SELECT * FROM $table_name");

    return $row;
}

//function to store the sms sent
function store_sent_sms($order_id = null, $phone_number, $message, $current_status_text = '', $messageId, $user_id = null, $source)
{
    global $wpdb;
    if (!is_null($order_id)) {
        $order = wc_get_order($order_id);
        $current_status_slug = $order->get_status();
        $current_status_text = wc_get_order_status_name($current_status_slug);
    }
    $table_name = $wpdb->prefix . 'modulus_woo_text_history';

    // Insert data into the custom table
    $wpdb->insert(
        $table_name,
        array(
            'order_id' => $order_id,
            'phone_number' => $phone_number,
            'message' => $message,
            'order_status_log' => $current_status_text,
            'message_id' => $messageId,
            'user_id' => $user_id,
            'source' => $source,
        ),
        array('%d', '%s', '%s', '%s', '%s', '%d', '%s')
    );
}

function sms_history_meta_box_content($post)
{
    global $wpdb;
    $order_id = $post->ID;

    // Define your custom table name
    $table_name = $wpdb->prefix . 'modulus_woo_text_history';

    // Retrieve sent messages for the current order from the custom table
    $messages = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE order_id = %d ORDER BY sent_at DESC", $order_id));

    // Display sent messages
    echo '<h2><b>Ιστορικό SMS</b></h2>';
    if ($messages) {
        echo '<table class="sms-history-table custom-table-history">';
        echo '<thead><tr><th class="custom-th-history"></th><th class="custom-th-history"></th><th class="custom-th-history"></th><th class="custom-th-history"></th><th class="custom-th-history"></th></tr></thead>';
        echo '<tbody>';
        foreach ($messages as $message) {
            echo '<tr>';
            echo '<td class="custom-td-history">' . esc_html($message->phone_number) . '</td>';

            // Output the message without truncation if it's 10 characters or below
            if (mb_strlen($message->message) <= 20) {
                echo '<td class="custom-td-history message-cell" data-full-message="' . esc_attr($message->message) . '">' . esc_html($message->message) . '</td>';
            } else {
                // For messages longer than 10 characters, truncate and add the image with tooltip
                $truncatedMessage = mb_substr($message->message, 0, 20);
                echo '<td class="custom-td-history message-cell" data-full-message="' . esc_attr($message->message) . '">' . esc_html($truncatedMessage) . ' <img src="' . plugin_dir_url(__FILE__) . 'assets/images/exc.png" alt="Message Image" class="message-image">
                <div class="sms-msg-history" style="display:none">"' . esc_attr($message->message) . '"</div>
                </td>';
            }

            echo '<td class="custom-td-history">' . esc_html($message->sent_at) . '</td>';
            echo '<td class="custom-td-history">' . esc_html($message->order_status_log) . '</td>';
            echo '<td class="custom-td-history"><button class="resend-sms-button resend-custom-button" data-phone="' . esc_attr($message->phone_number) . '" data-message="' . esc_attr($message->message) . '"><img title="Επανάληψη αποστολής μηνύματος" src="' . plugin_dir_url(__FILE__) . 'assets/images/resend.png" alt="Button Image" style="width: 50px;"></button></td>';
            echo '</tr>';
            echo '<tr class="modulus-callback-message">';
            echo '<td colspan="5" class="custom-td-history">' . esc_html($message->callback_code > 0 ? $message->callback_code : '') . ' ' . esc_html($message->callback_message) . '</td>';
            //echo '<td class="custom-td-history">' . esc_html($message->sent_at) . '</td>';

            echo '</tr>';
        }
        echo '</tbody>';
        echo '</table>';
    } else {
        echo '<p class="no-messages">No SMS messages sent for this order.</p>';
    }
}

//calls the send sms function

function send_sms_callback()
{
    if (isset($_POST['orderId']) && isset($_POST['phoneNumber']) && isset($_POST['message'])) {
        $orderId = sanitize_text_field($_POST['orderId']);
        $phoneNumber = sanitize_text_field($_POST['phoneNumber']);

        $placeholders = array("{first_name}", "{last_name}", "{order_id}", "{order_total}");
        $order = wc_get_order($orderId);
        $first_name = $order->get_billing_first_name();
        $last_name = $order->get_billing_last_name();
        $user_name = $first_name . ' ' . $last_name;
        $order_currency = $order->get_currency();
        $order_total = $order->get_total() . $order_currency;
        $current_status_text = $order->get_status();

        $values = array($first_name, $last_name, $orderId, $order_total);

        $smsreplace = str_replace($placeholders, $values, $_POST['message']);
        $smsMessage = $smsreplace;


        if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
            $phoneNumber = '30' . $phoneNumber;
        }

        if (fetch_constraints() === 'true') {

            $modulus_settings = woo_sms_alerts_get_sender_settings();

            $sender_id = $modulus_settings->sender;
            $api_url_info = $modulus_settings->api_url;
            $routing_info = $modulus_settings->routing_option;
            $api_token = $modulus_settings->api_token;


            // Prepare SMS data
            if ($routing_info == 'sms') {
                $smsData = array(
                    'priority' => 3,
                    'recipients' => array(
                        array(
                            'msisdn' => $phoneNumber
                        )
                    ),
                    'sms' => array(
                        'sender' => $sender_id,
                        'text' => $smsMessage,
                        'encoding' => 'gsm',
                        'validityPeriod' => 86400
                    ),
                    'dlr' => true,
                    'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                    'externalTags' => array('string')
                );

            } else if ($routing_info == 'viber') {


                $smsData = array(
                    'routing' => 'viber_AmdTelecom_Trans',
                    'priority' => 3,
                    'recipients' => array(
                        array(
                            'msisdn' => $phoneNumber,
                        )
                    ),
                    'viber' => array(
                        'sender' => $sender_id,
                        'type' => 'text',
                        'text' => $smsMessage,
                        'encoding' => 'gsm',
                        'validityPeriod' => 86400
                    ),
                    'dlr' => true,
                    'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                    'externalTags' => array('string')
                );

            } else if ($routing_info == 'viber2sms') {


                $smsData = array(
                    'routing' => 'viber_AmdTelecom_Trans_SMS',
                    'priority' => 3,
                    'recipients' => array(
                        array(
                            'msisdn' => $phoneNumber,
                        )

                    ),
                    'viber' => array(
                        'sender' => $sender_id,
                        'type' => 'text',
                        'text' => $smsMessage,
                        'encoding' => 'gsm',
                        'validityPeriod' => 86400
                    ),
                    'sms' => array(
                        'sender' => $sender_id,
                        'text' => $smsMessage,
                        'encoding' => 'gsm',
                        'validityPeriod' => 86400
                    ),
                    'dlr' => true,
                    'dlrUrl' => 'https://test.gr/callbackmessage',
                    'externalTags' => array('string')
                );

            }


            // Convert SMS data to JSON
            $jsonData = json_encode($smsData);

            // cURL request to send SMS
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url_info);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $api_token
                )
            );
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $response = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            curl_close($ch);

            $json_response = json_decode($response);

            if (isset($json_response->messages[0]->messageId)) {
                $messageId = $json_response->messages[0]->messageId;
            }

            store_sent_sms($orderId, $phoneNumber, $smsMessage, $current_status_text, $messageId, null, 'order');

            echo json_encode(array('Success' => 'True', 'MessageId' => $messageId));
        } else {
            add_to_queue($phoneNumber, $smsMessage, 'order', null, $orderId);
            echo json_encode(array('success' => true, 'response' => 'ADDED TO QUEUE'));
        }
    } else {
        echo json_encode(array('error' => 'Invalid data'));
    }

    wp_die(); // This is required to terminate immediately and return a proper response
}

add_action('wp_ajax_modulus_send_sms', 'send_sms_callback');


// Function to output the content of our custom meta box
//function for the order sms box
function woo_sms_alerts_meta_box_content($post)
{

    $sms_options = get_presets();

    ?>
    <script>
        function check_char_count(field, modal) {
            var charCount = jQuery(field).val().length;
            console
            var result;

            if (charCount >= 160 && charCount <= 306) {
                result = 2;
            } else if (charCount > 306) {
                result = Math.ceil((charCount - 306) / 156) + 2;
            } else {
                result = 1;
            }
            if (charCount > 0) {
                jQuery("" + modal + " #character_count").html(
                    "<strong>" + charCount + "</strong>" + " Χαρακτήρες"
                );
                jQuery("" + modal + " #character_warning").html(
                    "Το μήνυμα θα αποσταλεί σε <strong>" + result + " </strong> SMS"
                );
            }


        }

        jQuery(document).ready(function ($) {
            jQuery(".sms-alerts-meta-box #modulus_sms_message").on("input", function () {

                var charCount = jQuery(this).val().length;

                var result;

                if (charCount >= 160 && charCount <= 306) {
                    result = 2;
                } else if (charCount > 306) {
                    result = Math.ceil((charCount - 306) / 156) + 2;
                } else {
                    result = 1;
                }

                jQuery(".sms-alerts-meta-box #character_count").html(
                    "<strong>" + charCount + "</strong>" + " Χαρακτήρες"
                );

                jQuery(".sms-alerts-meta-box  #character_warning").html(
                    "Το μήνυμα θα αποσταλεί σε <strong>" + result + " </strong> SMS."
                );

            });
        });
    </script>
    <div class="sms-alerts-meta-box">
        <div class="form-row">
            <label for="test_options">
                <?php _e('Επιλέξτε πρότυπο SMS', 'woo-sms-alerts'); ?>
            </label>
            <div class="edit-templates">
                <a href="<?php echo home_url('/wp-admin/admin.php?page=woo-sms-settings&tab=templates'); ?>"
                   target="_blank">
                    <?php _e('Επεξεργασία πρωτύπων', 'woo-sms-alerts'); ?>
                </a>
                <img src="<?php echo plugin_dir_url(__FILE__); ?>assets/images/form.png" alt=" " class="icon-image">

            </div>
            <select id="test_options" name="test_options">
                <option value="">
                    <?php _e('-Επιλέξτε-', 'woo-sms-alerts'); ?>
                </option>
                <?php
                foreach ($sms_options as $value) {
                    echo '<option value="' . esc_attr($value['id']) . '">' . esc_html($value['title']) . '</option>';
                }
                ?>
            </select>
        </div>

        <div class="form-row">
            <label for="customer_phone" class="required-field">
                <?php _e('Τηλέφωνο Πελάτη', 'woo-sms-alerts'); ?>
            </label>
            <input type="text" id="modulus_customer_phone" name="customer_phone">
            <p class="hint-text">Η μορφή του τηλεφώνου για Ελλάδα είναι 3069ΧΧΧΧΧΧΧΧ</p>
        </div>
        <div class="form-row" style="margin-bottom:1em;">
            <?php echo sms_instructions_text();
            echo instructions_sms_list("order");
            ?>


        </div>
        <div class="form-row">
            <label for="modulus_sms_message" class="required-field">
                <?php _e('Μήνυμα', 'woo-sms-alerts'); ?> <span class="woocommerce-help-tip" tabindex="1"
                                                               aria-label="<?php _e('Add a message to send to your customer.', 'woo-sms-alerts'); ?>"></span>
            </label>
            <textarea id="modulus_sms_message" name="sms_message" rows="5" cols="20"></textarea>
        </div>
        <div class="form-row"
             style="margin-top:1em!important;display:flex;justfy-content:flex-end;width:100%!important;">

            <span id="character_count"></span>
            &nbsp;
            <span id="character_warning"></span>

        </div>
        <div class="form-row align-right">
            <button class="button button-primary" id="send-sms-button">
                <?php _e('Στείλε SMS', 'woo-sms-alerts'); ?>
            </button>
        </div>
    </div>
    <script>

        jQuery(document).ready(function ($) {
            $('#test_options').on('change', function () {
                var selectedTemplateId = $(this).val();


                if (selectedTemplateId !== '') {
                    // Call AJAX function to fetch template details based on selectedTemplateId
                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: 'POST',
                        data: {
                            action: 'get_template_details',
                            templateId: selectedTemplateId
                        },
                        success: function (response) {
                            // Parse JSON response to get template details

                            // Fill the textarea with the message from the selected template
                            var trimmedResponse = response.trim();
                            $('#modulus_sms_message').val(trimmedResponse);
                            check_char_count('#modulus_sms_message', '.sms-alerts-meta-box')
                        }
                    });
                } else {
                    // If no option is selected, clear the textarea
                    $('#modulus_sms_message').val('');
                }
            });
        });
    </script>

    <script>
        jQuery(document).ready(function ($) {

            $('#modulus_customer_phone').val(<?php echo get_post_meta($post->ID, '_billing_phone', true); ?>)


            $('#send-sms-button').on('click', function (e) {

                e.preventDefault();
                var smsMessage = $('#modulus_sms_message').val();
                var phoneNumber = $('#modulus_customer_phone').val();
                var orderId = <?php echo $post->ID; ?>

                // Check if the message box is empty
                if (smsMessage.trim() === '') {
                    // Show a warning message
                    alert('Please enter a message before sending.');
                } else {

                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        method: 'POST',
                        data: {
                            action: 'modulus_send_sms',
                            orderId: orderId,
                            phoneNumber: phoneNumber,
                            message: smsMessage
                        },
                        success: function (response) {
                            // Handle success response if needed
                            //  console.log(response);
                            alert('Message sent!');

                            // $('#modulus_sms_message').val('');
                            // $('#modulus_customer_phone').val('');
                        },
                        error: function (error) {
                            // Handle error response if needed
                            console.error(error);
                        }
                    });


                }
            });

        });

    </script>

    <script>
        jQuery(document).ready(function ($) {
            $(".resend-sms-button").click(function () {


                var phoneNumber = $(this).data("phone");
                var message = $(this).data("message");
                var orderId = <?php echo $post->ID; ?>

                // Show confirmation dialog
                var confirmResend = confirm("Are you sure you want to resend this SMS?");

                // If user confirms, populate the SMS message and phone number fields and trigger the click event
                if (confirmResend) {
                    // $("#modulus_sms_message").val(message);
                    //  $("#modulus_customer_phone").val(phoneNumber);
                    // $("#send-sms-button").click();
                    // console.log("Button clicked");

                    // alert(phoneNumber+ ' - '+ message + ' - ' + orderId);

                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        method: 'POST',
                        data: {
                            action: 'modulus_send_sms',
                            orderId: orderId,
                            phoneNumber: phoneNumber,
                            message: message
                        },
                        success: function (response) {
                            // Handle success response if needed
                            // console.log(response);
                            alert('Message sent!');

                            // $('#modulus_sms_message').val('');
                            // $('#modulus_customer_phone').val('');
                        },
                        error: function (error) {
                            // Handle error response if needed
                            console.error(error);
                        }
                    });

                }


            });


        });


    </script>

    <?php

    sms_history_meta_box_content($post);
}

// Function to add our meta box to the order detail page
function woo_sms_alerts_add_meta_box()
{
    add_meta_box(
        'woo_sms_alerts_meta_box',
        __('Modulus SMS', 'woo-sms-alerts'),
        'woo_sms_alerts_meta_box_content',
        'shop_order',
        'normal', // This places it in the right column
        'default'
    );
}

add_action('add_meta_boxes', 'woo_sms_alerts_add_meta_box');


// Ensure our previously defined save function is still there
//add_action('save_post', 'woo_sms_alerts_save_order_custom_message');


/*
function woo_sms_alerts_enqueue_admin_styles($hook) {
    // Enqueue styles for WooCommerce order edit screen
    $screen = get_current_screen();
    if ($screen->id === 'shop_order') {
        wp_enqueue_style(
            'woo-sms-alerts-admin-style', 
            plugin_dir_url(__FILE__) . 'assets/admin-style.css',
            [],
            '1.0.32'
        );
    }
    
    // Enqueue styles for the plugin's settings page
    if ($hook === 'woocommerce_page_woo-sms-alerts-settings') {
        wp_enqueue_style(
            'woo-sms-alerts-admin-style',
            plugin_dir_url(__FILE__) . 'assets/images/admin-style.css',
            [],
            '1.0.32'
        );
    }
}
*/


function on_status_change_send_sms_callback($order_id, $order_template, $current_status, $billing_phone, $user_name, $order_total, $last_name)
{


    if (!$order_id) {
        return;
    }
    $current_user_id = get_current_user_id();
    if (check_sms_consent_status() == true) {
        if (get_post_meta($order_id, 'sms_consent_order', true) == 'yes' || get_user_meta($current_user_id, 'sms_consent', true) == 'yes') {


            global $wpdb;

            $table_name_orders = $wpdb->prefix . 'modulus_woo_sms_templates';

            // Get the sms_sent value based on the order_status and order_template conditions
            $get_message = $wpdb->get_var(
                $wpdb->prepare(
                    "SELECT message FROM {$table_name_orders} WHERE id = %d",
                    $order_template
                )
            );


            $orderId = sanitize_text_field($order_id);

            $phoneNumber = sanitize_text_field($billing_phone);

            $placeholders = array("{first_name}", "{last_name}", "{order_id}", "{order_total}");


            $values = array($user_name, $last_name, $orderId, $order_total);

            $smsreplace = str_replace($placeholders, $values, $get_message);

            $smsMessage = $smsreplace;

            if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
                $phoneNumber = '30' . $phoneNumber;
            }


            $modulus_settings = woo_sms_alerts_get_sender_settings();
            $sender_id = $modulus_settings->sender;
            $api_url_info = $modulus_settings->api_url;
            $routing_info = $modulus_settings->routing_option;
            $api_token = $modulus_settings->api_token;

            if ($routing_info == 'sms') {
                $smsData = array(
                    'priority' => 3,
                    'recipients' => array(
                        array(
                            'msisdn' => $phoneNumber
                        )
                    ),
                    'sms' => array(
                        'sender' => $sender_id,
                        'text' => $smsMessage,
                        'encoding' => 'gsm',
                        'validityPeriod' => 86400
                    ),
                    'dlr' => true,
                    'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                    'externalTags' => array('string')
                );
            } else if ($routing_info == 'viber') {

                $smsData = array(
                    'routing' => 'viber_AmdTelecom_Trans',
                    'priority' => 3,
                    'recipients' => array(
                        array(
                            'msisdn' => $phoneNumber,
                        )
                    ),
                    'viber' => array(
                        'sender' => $sender_id,
                        'type' => 'text',
                        'text' => $smsMessage,
                        'encoding' => 'gsm',
                        'validityPeriod' => 86400
                    ),
                    'dlr' => true,
                    'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                    'externalTags' => array('string')
                );

            } else if ($routing_info == 'viber2sms') {

                $smsData = array(
                    'routing' => 'viber_AmdTelecom_Trans_SMS',
                    'priority' => 3,
                    'recipients' => array(
                        array(
                            'msisdn' => $phoneNumber,
                        )

                    ),
                    'viber' => array(
                        'sender' => $sender_id,
                        'type' => 'text',
                        'text' => $smsMessage,
                        'encoding' => 'gsm',
                        'validityPeriod' => 86400
                    ),
                    'sms' => array(
                        'sender' => $sender_id,
                        'text' => $smsMessage,
                        'encoding' => 'gsm',
                        'validityPeriod' => 86400
                    ),
                    'dlr' => true,
                    'dlrUrl' => 'https://test.gr/callbackmessage',
                    'externalTags' => array('string')
                );

            }


            $jsonData = json_encode($smsData);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url_info);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $api_token
                )
            );
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);


            $response = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);


            curl_close($ch);

            $json_response = json_decode($response);

            if (isset($json_response->messages[0]->messageId)) {
                $messageId = $json_response->messages[0]->messageId;
            }

            store_sent_sms($orderId, $phoneNumber, $smsMessage, $current_status, $messageId, null, 'order');

            return true;
        }
    } else {
        global $wpdb;

        $table_name_orders = $wpdb->prefix . 'modulus_woo_sms_templates';

        // Get the sms_sent value based on the order_status and order_template conditions
        $get_message = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT message FROM {$table_name_orders} WHERE id = %d",
                $order_template
            )
        );


        $orderId = sanitize_text_field($order_id);

        $phoneNumber = sanitize_text_field($billing_phone);

        $placeholders = array("{first_name}", "{last_name}", "{order_id}", "{order_total}");


        $values = array($user_name, $last_name, $orderId, $order_total);

        $smsreplace = str_replace($placeholders, $values, $get_message);

        $smsMessage = $smsreplace;

        if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
            $phoneNumber = '30' . $phoneNumber;
        }


        $modulus_settings = woo_sms_alerts_get_sender_settings();
        $sender_id = $modulus_settings->sender;
        $api_url_info = $modulus_settings->api_url;
        $routing_info = $modulus_settings->routing_option;
        $api_token = $modulus_settings->api_token;

        if ($routing_info == 'sms') {
            $smsData = array(
                'priority' => 3,
                'recipients' => array(
                    array(
                        'msisdn' => $phoneNumber
                    )
                ),
                'sms' => array(
                    'sender' => $sender_id,
                    'text' => $smsMessage,
                    'encoding' => 'gsm',
                    'validityPeriod' => 86400
                ),
                'dlr' => true,
                'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                'externalTags' => array('string')
            );
        } else if ($routing_info == 'viber') {

            $smsData = array(
                'routing' => 'viber_AmdTelecom_Trans',
                'priority' => 3,
                'recipients' => array(
                    array(
                        'msisdn' => $phoneNumber,
                    )
                ),
                'viber' => array(
                    'sender' => $sender_id,
                    'type' => 'text',
                    'text' => $smsMessage,
                    'encoding' => 'gsm',
                    'validityPeriod' => 86400
                ),
                'dlr' => true,
                'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                'externalTags' => array('string')
            );

        } else if ($routing_info == 'viber2sms') {

            $smsData = array(
                'routing' => 'viber_AmdTelecom_Trans_SMS',
                'priority' => 3,
                'recipients' => array(
                    array(
                        'msisdn' => $phoneNumber,
                    )

                ),
                'viber' => array(
                    'sender' => $sender_id,
                    'type' => 'text',
                    'text' => $smsMessage,
                    'encoding' => 'gsm',
                    'validityPeriod' => 86400
                ),
                'sms' => array(
                    'sender' => $sender_id,
                    'text' => $smsMessage,
                    'encoding' => 'gsm',
                    'validityPeriod' => 86400
                ),
                'dlr' => true,
                'dlrUrl' => 'https://test.gr/callbackmessage',
                'externalTags' => array('string')
            );

        }


        $jsonData = json_encode($smsData);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url_info);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $api_token
            )
        );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);


        $response = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);


        curl_close($ch);

        $json_response = json_decode($response);

        if (isset($json_response->messages[0]->messageId)) {
            $messageId = $json_response->messages[0]->messageId;
        }

        store_sent_sms($orderId, $phoneNumber, $smsMessage, $current_status, $messageId, null, 'order');

        return true;
    }
}

function update_order_status_modulus_send_sms($order_id)
{
    if (!$order_id) {
        return;
    }

    global $wpdb;

    $order = wc_get_order($order_id);
    $billing_phone = $order->get_billing_phone();
    $current_status = $order->get_status();

    $first_name = $order->get_billing_first_name();
    $last_name = $order->get_billing_last_name();
    $user_name = $first_name . ' ' . $last_name;

    $order_currency = $order->get_currency();
    $order_total = $order->get_total() . $order_currency;

    $current_status = 'wc-' . $current_status;

    $language = defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : 'el';

    $table_name_orders = $wpdb->prefix . 'modulus_woo_orders_board';

    // Get the sms_sent value based on the order_status and order_template conditions
    $sms_sent_value = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT sms_sent FROM {$table_name_orders} WHERE order_status = %s AND order_template != %d and lang = %s",
            $current_status,
            0,
            $language
        )
    );

    if ($sms_sent_value) {
        // sms_sent value was fetched successfully
        if ($sms_sent_value == '1') {

            $order_template = $wpdb->get_var(
                $wpdb->prepare(
                    "SELECT order_template FROM {$table_name_orders} WHERE order_status = %s and lang = %s",
                    $current_status,
                    $language
                )
            );

            on_status_change_send_sms_callback($order_id, $order_template, $current_status, $billing_phone, $first_name, $order_total, $last_name);

        }
    } else {
        // The query didn't return a value
        // error_log("No rows found for order_status: $current_status with order_template not equal to 0 in $table_name_orders");
    }


}

add_action('woocommerce_order_status_changed', 'update_order_status_modulus_send_sms');

//add_action( 'woocommerce_new_order', 'update_order_status_modulus_send_sms' );


//dynamically brings the saved template message from the template chosen in the order sms box

function get_template_message_from_database($templateId)
{
    global $wpdb;

    $templateId = $_POST['templateId'];

    $table_name = $wpdb->prefix . 'modulus_woo_sms_templates';


    $template = $wpdb->get_row($wpdb->prepare("SELECT message FROM $table_name WHERE id = %d", $templateId), ARRAY_A);


    echo $template['message'];

    wp_die();

}

//hooks the functions of the file with the css file

function woo_sms_alerts_enqueue_admin_styles($hook)
{
    wp_enqueue_style(
        'woo-sms-alerts-admin-style',
        plugin_dir_url(__FILE__) . 'assets/admin-style.css',
        [],
        '1.2.79'
    );

    wp_enqueue_style(
        'woo-sms-alerts-admin-style-bootsrap',
        'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css',
        [],
        '1.2.79'
    );
}


add_action('admin_enqueue_scripts', 'woo_sms_alerts_enqueue_admin_styles');
add_action('wp_ajax_get_template_details', 'get_template_message_from_database');


add_action('wp_enqueue_scripts', 'enqueue_custom_script');

function enqueue_custom_script()
{
    // Check if we're on a product page
    if (is_product()) {
        wp_enqueue_script('custom-script', plugin_dir_url(__FILE__) . 'assets/js/modulus_custom_js.js', array('jquery'), '1.30', true);
    }
}

/*
function validate_and_modify_phone_number($order_id) {
    $order = wc_get_order($order_id);
    $phone_number = $order->get_billing_phone();

    // Check if phone number starts with "30"
    if (strpos($phone_number, '30') !== 0 || strpos($phone_number, '+30') !== 0 ) {
        // If not, prepend "30" to the phone number
        $phone_number = '30' . $phone_number;

        // Update the order with the modified phone number
        $order->set_billing_phone($phone_number);
        $order->save();
    }

    // Check the length of the phone number
    if (strlen($phone_number) !== 12) {
        ?>
        <script type="text/javascript">
            jQuery(document).ready(function($) {
                alert('Invalid phone number. Please check the phone number in the order.');
            });
        </script>
        <?php
    }
}

// Hook into WooCommerce new order creation
add_action('woocommerce_new_order', 'validate_and_modify_phone_number', 10, 1);

function set_order_phone_number($order_id, $phone_number) {
    $order = wc_get_order($order_id);
    $formatted_phone_number = '30' . preg_replace('/[^0-9]/', '', $phone_number); // Ensure '30' prefix and remove non-numeric characters
    $order->set_billing_phone($formatted_phone_number);
    $order->save();
}

function get_order_phone_number($order_id) {
    $order = wc_get_order($order_id);
    return $order->get_billing_phone();
}

function save_validated_phone_number($order_id, $phone_number) {
    // Validate the phone number here if needed

    // Save the validated phone number
    set_order_phone_number($order_id, $phone_number);
}
*/