<?php

//// AJAX FUNCTIONS  /////

function send_sms_mass_callback()
{

    if (isset($_POST['user_ids']) && isset($_POST['message'])) {

        $phoneNumbers = $_POST['phoneNumber'];
        $user_ids = $_POST['user_ids'];
        $smsMessage_original = sanitize_text_field($_POST['message']);
        $modulus_settings = woo_sms_alerts_get_sender_settings();
        $sender_id = $modulus_settings->sender;
        $api_url_info = $modulus_settings->api_url;
        $routing_info = $modulus_settings->routing_option;
        $api_token = $modulus_settings->api_token;
        if (check_sms_consent_status() == true) {

            // foreach ($phoneNumbers as $index=>$phoneNumber) {
            foreach ($user_ids as $id) {
                if (get_user_meta($id, 'sms_consent', true) == 'yes') {
                    $phoneNumber = get_user_meta($id, 'billing_phone', true);
                    $first_name = get_user_meta($id, 'first_name', true);
                    $last_name = get_user_meta($id, 'last_name', true);
                    // $user_name =$first_name .$last_name;
                    $placeholders = array("{first_name}", "{last_name}");

                    $values = array($first_name, $last_name);

                    $smsreplace = str_replace($placeholders, $values, $smsMessage_original);

                    $smsMessage = $smsreplace;

                    if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
                        $phoneNumber = '30' . $phoneNumber;
                    }
                    if (fetch_constraints() === 'true') {
                        $smsData = array(
                            'priority' => 3,
                            'recipients' => array(
                                array(
                                    'msisdn' => $phoneNumber
                                )
                            ),
                            'sms' => array(
                                'sender' => $sender_id,
                                'text' => $smsMessage,
                                'encoding' => 'gsm',
                                'validityPeriod' => 86400
                            ),

                            'dlr' => true,
                            'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                            'externalTags' => array('string')
                        );


                        $jsonData = json_encode($smsData);


                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, $api_url_info);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                        curl_setopt(
                            $ch,
                            CURLOPT_HTTPHEADER,
                            array(
                                'Content-Type: application/json',
                                'Authorization: Bearer ' . $api_token
                            )
                        );
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                        $response = curl_exec($ch);
                        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                        curl_close($ch);
                        $json_response = json_decode($response);

                        if (isset($json_response->messages[0]->messageId)) {
                            $messageId = $json_response->messages[0]->messageId;
                        }
                        // store_sent_sms(null, $phoneNumber, $smsMessage, '', $messageId, $id, 'mass_registered');
                        store_sms_logs_($id, $phoneNumber, $smsMessage, 'user', null, $messageId);

                        echo json_encode(array('success' => true, 'response' => $response, 'httpcode' => $httpcode));
                    } else {
                        add_to_queue($phoneNumber, $smsMessage, 'user', $id, null);
                        echo json_encode(array('success' => true, 'response' => 'ADDED TO QUEUE'));
                    }
                }
            }

        } else {
            foreach ($user_ids as $id) {

                $phoneNumber = get_user_meta($id, 'billing_phone', true);
                $first_name = get_user_meta($id, 'first_name', true);
                $last_name = get_user_meta($id, 'last_name', true);
                // $user_name =$first_name .$last_name;
                $placeholders = array("{first_name}", "{last_name}");

                $values = array($first_name, $last_name);

                $smsreplace = str_replace($placeholders, $values, $smsMessage_original);

                $smsMessage = $smsreplace;

                if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
                    $phoneNumber = '30' . $phoneNumber;
                }
                if (fetch_constraints() === 'true') {
                    $smsData = array(
                        'priority' => 3,
                        'recipients' => array(
                            array(
                                'msisdn' => $phoneNumber
                            )
                        ),
                        'sms' => array(
                            'sender' => $sender_id,
                            'text' => $smsMessage,
                            'encoding' => 'gsm',
                            'validityPeriod' => 86400
                        ),

                        'dlr' => true,
                        'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                        'externalTags' => array('string')
                    );


                    $jsonData = json_encode($smsData);


                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $api_url_info);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                    curl_setopt(
                        $ch,
                        CURLOPT_HTTPHEADER,
                        array(
                            'Content-Type: application/json',
                            'Authorization: Bearer ' . $api_token
                        )
                    );
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                    $response = curl_exec($ch);
                    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                    curl_close($ch);
                    $json_response = json_decode($response);

                    if (isset($json_response->messages[0]->messageId)) {
                        $messageId = $json_response->messages[0]->messageId;
                    }
                    // store_sent_sms(null, $phoneNumber, $smsMessage, '', $messageId, $id, 'mass_registered');
                    store_sms_logs_($id, $phoneNumber, $smsMessage, 'user', null, $messageId);

                    echo json_encode(array('success' => true, 'response' => $response, 'httpcode' => $httpcode));
                } else {
                    add_to_queue($phoneNumber, $smsMessage, 'user', $id, null);
                    echo json_encode(array('success' => true, 'response' => 'ADDED TO QUEUE'));
                }
            }
        }
    } else {
        echo json_encode(array('error' => 'Invalid data'));
    }

    wp_die();

}

add_action('wp_ajax_send_sms_mass_callback', 'send_sms_mass_callback');


/// GUEST AJAX ///

function send_sms_mass_callback_guest()
{
    if (isset($_POST['phoneNumber']) && isset($_POST['message'])) {

        $phoneNumbers = $_POST['phoneNumber'];
        $user_ids = $_POST['order_id'];
        $smsMessage = sanitize_text_field($_POST['message']);
        $modulus_settings = woo_sms_alerts_get_sender_settings();
        $sender_id = $modulus_settings->sender;
        $api_url_info = $modulus_settings->api_url;
        $routing_info = $modulus_settings->routing_option;
        $api_token = $modulus_settings->api_token;
        $data = array();
        // foreach ($phoneNumbers as $index=>$phoneNumber) {
        //     $data = array(
        //         'user_id' => $user_ids[$index],
        //         'phone'   => $phoneNumber
        //     );


        //     $response_data[] = $data;

        // }

        if (check_sms_consent_status() == true) {
            foreach ($phoneNumbers as $index => $phoneNumber) {
                // foreach ($user_ids as $id) {
                //     $phoneNumber = get_user_meta($id, 'billing_phone', true);

                if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
                    $phoneNumber = '30' . $phoneNumber;
                }

                $order_id = $user_ids[$index];
                if (get_post_meta($order_id, 'sms_consent_order', true) == 'yes') {
                    $order = wc_get_order($order_id);
                    $first_name = $order->get_billing_first_name();
                    $last_name = $order->get_billing_last_name();
                    $user_name = $first_name . ' ' . $last_name;

                    $order_currency = $order->get_currency();
                    $order_total = $order->get_total() . $order_currency;

                    // $placeholders = array("{user_name}", "{order_id}", "{order_total}");
                    $placeholders = array("{first_name}", "{last_name}");

                    // $values = array($user_name, $order_id, $order_total);
                    $values = array($first_name, $last_name);
                    $smsreplace = str_replace($placeholders, $values, $_POST['message']);

                    $smsMessage = $smsreplace;

                    if (fetch_constraints() === 'true') {
                        $smsData = array(
                            'priority' => 3,
                            'recipients' => array(
                                array(
                                    'msisdn' => $phoneNumber
                                )
                            ),
                            'sms' => array(
                                'sender' => $sender_id,
                                'text' => $smsMessage,
                                'encoding' => 'gsm',
                                'validityPeriod' => 86400
                            ),
                            'dlr' => true,
                            'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                            'externalTags' => array('string')
                        );


                        $jsonData = json_encode($smsData);


                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, $api_url_info);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                        curl_setopt(
                            $ch,
                            CURLOPT_HTTPHEADER,
                            array(
                                'Content-Type: application/json',
                                'Authorization: Bearer ' . $api_token
                            )
                        );
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                        $response = curl_exec($ch);
                        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                        curl_close($ch);
                        $json_response = json_decode($response);

                        if (isset($json_response->messages[0]->messageId)) {
                            $messageId = $json_response->messages[0]->messageId;
                        }

                        // store_sent_sms($order_id, $phoneNumber, $smsMessage, '', $messageId, null, 'mass_orders');
                        store_sms_logs_(null, $phoneNumber, $smsMessage, 'mass_order', $order_id, $messageId);
                        echo json_encode(array('success' => true, 'response' => $response, 'httpcode' => $httpcode));
                    } else {
                        add_to_queue($phoneNumber, $smsMessage, 'mass_order', null, $order_id);
                        echo json_encode(array('success' => true, 'response' => 'ADDED TO QUEUE'));
                    }
                }
            }
        } else {
            foreach ($phoneNumbers as $index => $phoneNumber) {
                // foreach ($user_ids as $id) {
                //     $phoneNumber = get_user_meta($id, 'billing_phone', true);

                if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
                    $phoneNumber = '30' . $phoneNumber;
                }

                $order_id = $user_ids[$index];

                $order = wc_get_order($order_id);
                $first_name = $order->get_billing_first_name();
                $last_name = $order->get_billing_last_name();
                $user_name = $first_name . ' ' . $last_name;

                $order_currency = $order->get_currency();
                $order_total = $order->get_total() . $order_currency;

                // $placeholders = array("{user_name}", "{order_id}", "{order_total}");
                $placeholders = array("{first_name}", "{last_name}");

                // $values = array($user_name, $order_id, $order_total);
                $values = array($first_name, $last_name);
                $smsreplace = str_replace($placeholders, $values, $_POST['message']);

                $smsMessage = $smsreplace;

                if (fetch_constraints() === 'true') {
                    $smsData = array(
                        'priority' => 3,
                        'recipients' => array(
                            array(
                                'msisdn' => $phoneNumber
                            )
                        ),
                        'sms' => array(
                            'sender' => $sender_id,
                            'text' => $smsMessage,
                            'encoding' => 'gsm',
                            'validityPeriod' => 86400
                        ),
                        'dlr' => true,
                        'dlrUrl' => home_url('/wp-json/modulus-sms-alerts/v1/callback'),
                        'externalTags' => array('string')
                    );


                    $jsonData = json_encode($smsData);


                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $api_url_info);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                    curl_setopt(
                        $ch,
                        CURLOPT_HTTPHEADER,
                        array(
                            'Content-Type: application/json',
                            'Authorization: Bearer ' . $api_token
                        )
                    );
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                    $response = curl_exec($ch);
                    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                    curl_close($ch);
                    $json_response = json_decode($response);

                    if (isset($json_response->messages[0]->messageId)) {
                        $messageId = $json_response->messages[0]->messageId;
                    }

                    // store_sent_sms($order_id, $phoneNumber, $smsMessage, '', $messageId, null, 'mass_orders');
                    store_sms_logs_(null, $phoneNumber, $smsMessage, 'mass_order', $order_id, $messageId);
                    echo json_encode(array('success' => true, 'response' => $response, 'httpcode' => $httpcode));
                } else {
                    add_to_queue($phoneNumber, $smsMessage, 'mass_order', null, $order_id);
                    echo json_encode(array('success' => true, 'response' => 'ADDED TO QUEUE'));
                }
            }
        }
    }
}

add_action('wp_ajax_send_sms_mass_callback_guest', 'send_sms_mass_callback_guest');

function add_to_queue($phone_number, $smsMessage, $type, $user_id = null, $order_id = null)
{
    global $wpdb;
    $table_name = $wpdb->prefix . 'modulus_sms_to_send';

    // Insert data into the custom table
    $wpdb->insert(
        $table_name,
        array(

            'phone_number' => $phone_number,
            'message' => $smsMessage,
            'sent_at' => current_time('mysql', 1),
            'modified' => null,
            'user_id' => $user_id,
            'order_id' => $order_id,
            'type' => $type,
            'message_id' => null,
            'status' => 'todo',

        ),
        array(
            '%s', // phone_number
            '%s', // message
            '%s', // sent_at
            '%s', // modified
            '%d', // user_id
            '%d', // order_id
            '%s', // type
            '%s', // message_id
            '%s'  // status
        )
    );

}

function get_logs_makrup_query()
{
    global $wpdb;
    $user_id = $_POST['user_id'];
    $role = $_POST['role'];
    $tale_logs_name = $wpdb->prefix . 'modulus_woo_logs_history';
    if ($role === "registered") {
        $fetch_logs = $wpdb->get_results($wpdb->prepare("SELECT * FROM $tale_logs_name WHERE user_id= $user_id"));
    } else {
        $fetch_logs = $wpdb->get_results($wpdb->prepare("SELECT * FROM $tale_logs_name WHERE order_id= $user_id"));
    }

    $output = '';
    if ($fetch_logs) {

        $output .= '<table class="sms-history-table custom-table-history">';
        $output .= '<thead><tr><th class="custom-th-history">Αριθμός</th><th class="custom-th-history">Μήνυμα</th><th class="custom-th-history">Ημ/νία</th></tr></thead>';
        $output .= '<tbody>';
        foreach ($fetch_logs as $message) {
            $output .= '<tr>';
            $output .= '<td class="custom-td-history">' . esc_html($message->phone_number) . '</td>';

            // Output the message without truncation if it's 10 characters or below
            if (mb_strlen($message->message) <= 20) {
                $output .= '<td class="custom-td-history message-cell" data-full-message="' . esc_attr($message->message) . '">' . esc_html($message->message) . '</td>';
            } else {
                // For messages longer than 10 characters, truncate and add the image with tooltip
                $truncatedMessage = mb_substr($message->message, 0, 20);
                $output .= '<td class="custom-td-history message-cell" data-full-message="' . esc_attr($message->message) . '">' . esc_html($truncatedMessage) . ' <img src="' . plugin_dir_url(__FILE__) . '../assets/images/exc.png" alt="Message Image" class="message-image">
                <div class="sms-msg-history" style="display:none">"' . esc_attr($message->message) . '"</div>
                </td>';
            }

            $output .= '<td class="custom-td-history">' . esc_html($message->sent_at) . '</td>';

            //echo '<td class="custom-td-history"><button class="resend-sms-button resend-custom-button" data-phone="' . esc_attr($message->phone_number) . '" data-message="' . esc_attr($message->message) . '"><img title="Επανάληψη αποστολής μηνύματος" src="'.plugin_dir_url(__FILE__) .'assets/images/resend.png" alt="Button Image" style="width: 50px;"></button></td>';
            $output .= '</tr>';

        }
        $output .= '</tbody>';
        $output .= '</table>';

        wp_send_json_success($output);
    } else {
        wp_send_json_success('Δέν υπάρχουν εγγραφές');
    }
}

add_action('wp_ajax_get_logs_makrup_query', 'get_logs_makrup_query');

