<?php
/// THIS FILE IS FOR HANDLING THE MASS SMS FUNCTIONALITY

// INCLUDES //
require_once plugin_dir_path(__FILE__) . 'woocommerce_hooks/woo_hooks.php';
require_once plugin_dir_path(__FILE__) . 'views/modals.php';
require_once plugin_dir_path(__FILE__) . 'views/content.php';
require_once plugin_dir_path(__FILE__) . 'modulus_ajax_functions.php';
///// END INCLUDES ////

//// ADMIN MENU ////
function add_woo_sms_mass_menu()
{

    add_menu_page('Mass SMS', 'Mass SMS', 'manage_options', 'woo-sms-mass', 'mass_sms_send');
}
add_action('admin_menu', 'add_woo_sms_mass_menu', 10);

function mass_sms_send()
{

    ///THIS FUNCTION DISPLAYS THE ADMIN MENU ///
    ob_start();

    ?>
    <script>
        function check_char_count(field, modal) {
            var charCount = jQuery(field).val().length;
            console
            var result;

            if (charCount >= 160 && charCount <= 306) {
                result = 2;
            } else if (charCount > 306) {
                result = Math.ceil((charCount - 306) / 156) + 2;
            } else {
                result = 1;
            }
            if (charCount > 0) {
                jQuery("" + modal + " #character_count").html(
                    "<strong>" + charCount + "</strong>" + " Χαρακτήρες"
                );
                jQuery("" + modal + " #character_warning").html(
                    "Το μήνυμα θα αποσταλεί σε <strong>" + result + " </strong> SMS"
                );
            }


        }

        jQuery(document).ready(function ($) {

            jQuery("#message_user_field").on("input", function () {

                var charCount = jQuery(this).val().length;

                var result;

                if (charCount >= 160 && charCount <= 306) {
                    result = 2;
                } else if (charCount > 306) {
                    result = Math.ceil((charCount - 306) / 156) + 2;
                } else {
                    result = 1;
                }

                jQuery("#exampleModal #character_count").html(
                    "<strong>" + charCount + "</strong>" + " Χαρακτήρες"
                );

                jQuery("#exampleModal #character_warning").html(
                    "Το μήνυμα θα αποσταλεί σε <strong>" + result + " </strong> SMS."
                );

            });

            jQuery("#singularModal #message_user_field_").on("input", function () {

                var charCount = jQuery(this).val().length;

                var result;

                if (charCount >= 160 && charCount <= 306) {
                    result = 2;
                } else if (charCount > 306) {
                    result = Math.ceil((charCount - 306) / 156) + 2;
                } else {
                    result = 1;
                }

                jQuery("#singularModal #character_count").html(
                    "<strong>" + charCount + "</strong>" + " Χαρακτήρες"
                );

                jQuery("#singularModal #character_warning").html(
                    "Το μήνυμα θα αποσταλεί σε <strong>" + result + " </strong> SMS."
                );

            });


            check_char_count("#exampleModal #message_user_field", "#exampleModal");
            check_char_count("#singularModal #message_user_field_", "#singularModal");
        });


    </script>
    <style>
        .nav-pills {
            display: flex;
            gap: 1em;
            margin: 1em 0;
        }

        .nav-link {
            background-color: #A9A9A9;
            color: black;

        }

        .nav-link:hover {
            color: var(--bs-nav-pills-link-active-color);
            background-color: var(--bs-nav-pills-link-active-bg)
        }
       
        .modal-body textarea,
        .modal-body input,
        .modal-body select {
            width: 100% !important;
            min-width: 100% !important;
        }

        .form-row {
            border-top: 1px solid #dddddd;
        }

        .footer_modal_ {
            display: flex;
            gap: 1em;
            justify-content: space-between;
        }

        .footer_modal_ button {
            width: 50% !important;
            border-radius: 4px !important;
        }

        .footer_modal_ br {
            display: none !important;
        }

        button#send-sms-button-user {
            margin: 0 !important;
        }
    </style>
    <div class="wrap">

        <h2 style="text-align: center;">Μαζική αποστολή SMS</h2>
        <ul class="nav nav-pills">
            <li class="nav-item">
                <a class="nav-link <?php echo check_parameter('reg_users'); ?>" aria-current="page"
                    href="<?php echo admin_url();?>?page=woo-sms-mass&tab=reg_users">Εγγεγραμένοι χρήστες</a>
            </li>

            <li class="nav-item">
                <a class="nav-link <?php echo check_parameter('customer_users') ?>" aria-current="page"
                    href="<?php echo admin_url();?>?page=woo-sms-mass&tab=customer_users">Guest Χρήστες</a>
            </li>
        </ul>
        <div class="send_mass_sms_wrapper" style="margin-bottom:1em;">
            <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#exampleModal">
                Αποστολή
            </button>
        </div>


        <?php
        
        if (!isset($_GET['tab']) || $_GET['tab'] == 'reg_users') {
            echo get_registered_users();

        } else {
            echo users_customers();
        }

        echo ob_get_clean();
}

//// END ADMIN MENU ////

///// REUSABLE FUNCTIONS ///
function check_parameter($tab)
{
    if ($tab === 'reg_users' && !isset($_GET['tab'])) {
        echo 'active';
    } else {
        if (isset($_GET['tab']) && $_GET['tab'] == $tab) {
            echo 'active';
        }
    }

}

function get_user_field($user_id, $field, $single = true)
{
    $field = get_user_meta($user_id, $field, $single);
    if (!empty($field)) {
        return $field;
    } else {
        return '-';
    }
}

//// END REUSABLE FUNCTIONS /////

/////// SCRIPTS ///////
function send_sms_scripts()
{
    ?>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"
            integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL"
            crossorigin="anonymous"></script>
        <script>
            function send_sms_func(user_id, number, type_of_user) {
                // console.log(user_id);
                jQuery('#singularModal').modal('show');
                jQuery('#singularModal').find('#user_id').val(user_id);
                jQuery('#singularModal').find('#phone_number').val(number);

            }
            function send_sms_func_guest(user_id, number, type_of_user) {
                // console.log(user_id);
                jQuery('#singularModal_guest').modal('show');
                jQuery('#singularModal_guest').find('#user_id').val(user_id);
                jQuery('#singularModal_guest').find('#phone_number').val(number);

            }
            function sent_logs_sms_func(user_id, role) {
                console.log(user_id);
                var modal = jQuery('#logs_modal');
                modal.modal('show');

                jQuery.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    type: 'POST',
                    data: {
                        action: 'get_logs_makrup_query',
                        role: role,
                        user_id: user_id
                    },
                    success: function (response) {
                        console.log(response.data);
                        modal.find('.modal-body').html(response.data);
                        // var trimmedResponse = response.trim();
                        // $('#message_user_field').val(trimmedResponse);

                    }
                });
            }
            jQuery(document).ready(function () {
                jQuery('#singularModal').on('hidden.bs.modal', function (e) {
                    jQuery('#singularModal').find('#phone_number').val('');
                    jQuery("#template_options_").val([]);
                    jQuery('#message_user_field_').val('');

                    jQuery('#singularModal').find('#user_id').val('');
                });

                jQuery('#singularModal_guest').on('hidden.bs.modal', function (e) {
                    jQuery('#singularModal_guest').find('#phone_number').val('');
                    jQuery("#template_options_").val([]);
                    jQuery('#message_user_field_').val('');

                    jQuery('#singularModal_guest').find('#user_id').val('');
                });

                jQuery('#exampleModal').on('hidden.bs.modal', function (e) {

                    jQuery("#template_options").val([]);
                    jQuery('#message_user_field').val('');
                });

            });
        </script>
        <?php
}
//// FILTERS /////
function mass_sms_filters($url)
{

    ?>
        <style>
            label {
                font-weight: bold;
            }

            thead th div input {
                max-width: 100% !important;
                margin-left: 0 !important;
                border-top: 0 !important;
                border-right: 0 !important;
                border-left: 0 !important;
                border-bottom: 2px solid #848884;
                outline: 0;
                border-color: inherit;
                border-radius: 0 !important;
                -webkit-box-shadow: none;
                box-shadow: none;
            }
        </style>
        <thead>
            <tr>
                <th scope="col" class="manage-column column-cb check-column"
                    style="vertical-align:middle;padding: 0!important;"></th>
                <th scope="col" class="manage-column">
                    <div>
                        <label for="first_name">Ονομα</label>
                        <input type="text" class="form-control" id="first_name" aria-describedby="basic-addon3"
                            value="<?php echo isset($_GET['first_name']) ? sanitize_text_field($_GET['first_name']) : ''; ?>
"
                            onchange="window.location.href='<?php echo $url; ?>&first_name='+this.value">
                    </div>

                </th>

                <th scope="col" class="manage-column">
                    <div>
                        <label for="last_name">Επώνυμο</label>
                        <input type="text" class="form-control" id="last_name" aria-describedby="basic-addon3"
                            value="<?php echo isset($_GET['last_name']) ? sanitize_text_field($_GET['last_name']) : ''; ?>
"
                            onchange="window.location.href='<?php echo $url; ?>&last_name='+this.value">
                    </div>

                </th>

                <th scope="col" class="manage-column">
                    <div>
                        <label for="email">Email</label>
                        <input type="text" class="form-control" id="email" aria-describedby="basic-addon3"
                            value="<?php echo isset($_GET['email']) ? sanitize_email($_GET['email']) : ''; ?>
"
                            onchange="window.location.href='<?php echo $url; ?>&email='+this.value">
                    </div>

                </th>
                <th scope="col" class="manage-column">
                    <div>
                        <label for="number">Αριθμός</label>
                        <input type="text" class="form-control" id="number" aria-describedby="basic-addon3"
                            value="<?php echo isset($_GET['number']) ? sanitize_text_field($_GET['number']) : ''; ?>
"
                            onchange="window.location.href='<?php echo $url; ?>&number='+this.value">
                    </div>

                </th>
                <th scope="col" class="manage-column" style="font-weight:bold;vertical-align: text-top;">Μεμωνομένη αποστολή
                </th>
                <th scope="col" class="manage-column" style="font-weight:bold;vertical-align: text-top;">Ιστορικό SMS</th>
            </tr>
        </thead>

        <?php
}


/// STORE SMS LOGS FUNCTION ////
function store_sms_logs_($user_id = null, $phone_number, $message, $type, $order_id = null, $message_id)
{
    global $wpdb;


    $table_name = $wpdb->prefix . 'modulus_woo_logs_history';

    $wpdb->insert(
        $table_name,
        array(

            'phone_number' => $phone_number,
            'message' => $message,
            'sent_at' => current_time('mysql', 1),
            'user_id' => $user_id,
            'type' => $type,
            'order_id' => $order_id,
            'message_id' => $message_id,

        ),
        array('%d', '%s', '%s', '%s', '%s', '%d', '%s', '%s')
    );
}

