<?php

function check_sms_consent($phone_,$sms_meta) {
    if(!empty($phone_) && $sms_meta == 'yes'){
        return 'true';
    }else {
        return 'false';
    }
}

function get_registered_users()
{
  
    $current_page = isset($_GET['paged']) ? max(1, $_GET['paged']) : 1;
 
    $users_per_page = get_option('posts_per_page');
    $offset = ($current_page - 1) * $users_per_page;

    $args = array(
        'number' => $users_per_page,
        'offset' => $offset,
        'paged' => $current_page,
        'orderby' => array(
            'registered' => 'DESC',
            'meta_value' => 'DESC',

        ),
        'meta_query' => array(),
    );

    $name = isset($_GET['first_name']) ? sanitize_text_field($_GET['first_name']) : '';
    $last_name = isset($_GET['last_name']) ? sanitize_text_field($_GET['last_name']) : '';
    $email = isset($_GET['email']) ? sanitize_text_field($_GET['email']) : '';
    $number = isset($_GET['number']) ? sanitize_text_field($_GET['number']) : '';
    

    if (isset($name)) {

        $args['meta_query'] = array(
            array(
                'key' => 'first_name',
                'value' => $name,
                'compare' => 'LIKE'
            )
        );
    }

    if (isset($last_name)) {
        $args['meta_query'] = array(
            array(
                'key' => 'last_name',
                'value' => $last_name,
                'compare' => 'LIKE'
            )
        );

    }
    if (isset($email)) {
        $args['search'] = "*{$email}*";
        $args['search_columns'] = array(
            'user_login',
            'user_email',
        );
    }

    if (isset($number)) {
        $args['meta_query'][] = array(
            array(
                'key' => 'billing_phone',
                'value' => $number,
                'compare' => 'like'
            ),
        );

    }


    $users = get_users($args);

    echo send_sms_scripts();

    // echo modulus_collect_sms_to_send();
    
    echo '<table class="wp-list-table widefat fixed striped">';
    echo mass_sms_filters('/wp-admin/admin.php?page=woo-sms-mass');
    // echo '<thead><tr>';
    // echo '<th scope="col" class="manage-column column-cb check-column" style="vertical-align:middle;padding: 0!important;"><input type="checkbox"></th>';
    // echo '<th scope="col" class="manage-column">Ονομα</th>';
    // echo '<th scope="col" class="manage-column">Επώνυμο</th>';
    // echo '<th scope="col" class="manage-column">Email</th>';
    // echo '<th scope="col" class="manage-column">Αριθμός</th>';
    // echo '<th scope="col" class="manage-column">Μεμωνομένη αποστολή</th>';
    // echo '<th scope="col" class="manage-column">Ιστορικό SMS</th>';
    // echo '</tr></thead>';
    echo '<tbody>';

    $role="'registered'";
    foreach ($users as $user) {
        $phone_ = get_user_meta($user->ID, 'billing_phone', true);
        $sms_meta = get_user_meta($user->ID, 'sms_consent', true);
        if (!empty($phone_) && $sms_meta == 'yes') {
            $phone = '<input type="checkbox" value="' . esc_html($user->ID) . '" name="select_user[]">';
        } else {
            $phone = '<input type="checkbox" value="" disabled>';
        }

        echo '<tr>';
        echo '<th scope="row" class="check-column">' . $phone . '</th>';
        echo '<td><a href="/wp-admin/user-edit.php?user_id=' . $user->ID . '">' . esc_html($user->first_name) . '</a></td>';
        echo '<td><a href="/wp-admin/user-edit.php?user_id=' . $user->ID . '">' . esc_html($user->last_name) . '</a></td>';
        echo '<td><a href="/wp-admin/user-edit.php?user_id=' . $user->ID . '">' . esc_html($user->user_email) . '</a></td>';
        echo '<td>' . get_user_field($user->ID, 'billing_phone', true) . '</td>';
        echo '<td><button style="cursor:pointer!important" onclick="send_sms_func(' . $user->ID . ',' . $phone_ . ')" class="btn btn-success rounded-pill"><abbr style="cursor:pointer!important" title="Στείλτε στον ' . esc_html($user->user_email) . '"><i class="fa-solid fa-comment-sms"></i></abbr></button></td>';
        echo '<td><button style="cursor:pointer!important" onclick="sent_logs_sms_func(' . $user->ID . ','.$role.')" class="btn btn-success rounded-pill"><abbr style="cursor:pointer!important" title="Στείλτε στον ' . esc_html($user->user_email) . '"><i class="fa-solid fa-clock-rotate-left"></i></abbr></button></td>';
        echo '</tr>';
    }

    echo '</tbody></table>';

    // Pagination
    $total_users = count_users();
    $total_pages = ceil($total_users['total_users'] / $users_per_page);

    $pagination_links = paginate_links(
        array(
            'base' => add_query_arg('paged', '%#%'),
            'format' => '',
            'prev_text' => __('&laquo; Previous'),
            'next_text' => __('Next &raquo;'),
            'total' => $total_pages,
            'current' => $current_page,
        )
    );

    if ($pagination_links) {
        echo '<div class="tablenav">';
        echo '<div class="tablenav-pages">';
        echo $pagination_links;
        echo '</div>';
        echo '</div>';
    }

    echo '</div>';

    echo mass_sms_modal_function();
    echo mass_sms_modal_function_singular();
    echo logs_modal();
}

function users_customers()
{
    echo send_sms_scripts();

    // $name = sanitize_text_field($_GET['first_name']);
    // $last_name = sanitize_text_field($_GET['last_name']);
    // $email = sanitize_text_field($_GET['email']);
    // $number = sanitize_text_field($_GET['number']);
    $name = isset($_GET['first_name']) ? sanitize_text_field($_GET['first_name']) : '';
    $last_name = isset($_GET['last_name']) ? sanitize_text_field($_GET['last_name']) : '';
    $email = isset($_GET['email']) ? sanitize_text_field($_GET['email']) : '';
    $number = isset($_GET['number']) ? sanitize_text_field($_GET['number']) : '';
    $args = array(
        'orderby' => 'date',
        'order' => 'ASC',

    );

    $query = new WC_Order_Query();
   

    if (isset($name)) {
       
        $query->set( 'billing_first_name', $name );
    }

    if (isset($last_name)) {
        $query->set( 'billing_last_name', $last_name );
    }

    if (isset($email)) {
        $query->set( 'billing_email', $email );
    }

    if (isset($number)) {
        $query->set( 'billing_phone', $number );
    }

    $orders = $query->get_orders();
    
    // echo count($orders);
    // foreach($orders as $order) {
    //     print_r($order->get_id() .' '.$order->get_billing_email().'<br>');
    // }
    

    echo '<table class="wp-list-table widefat fixed striped">';
    // echo '<thead><tr>';
    // echo '<th scope="col" class="manage-column column-cb check-column" style="vertical-align:middle;padding: 0!important;"><input type="checkbox"></th>';
    // echo '<th scope="col" class="manage-column">Ονομα</th>';
    // echo '<th scope="col" class="manage-column">Επώνυμο</th>';
    // echo '<th scope="col" class="manage-column">Email</th>';
    // echo '<th scope="col" class="manage-column">Αριθμός</th>';
    // echo '<th scope="col" class="manage-column">Μεμωνομένη αποστολή</th>';
    // echo '<th scope="col" class="manage-column">Ιστορικό SMS</th>';
    // echo '</tr></thead>';
    echo mass_sms_filters('/wp-admin/admin.php?page=woo-sms-mass&tab=customer_users');
    echo '<tbody>';
    $role = "'customers'";
   
    if ($orders) {
        // Initialize an array to store the latest orders for each unique email
        $latest_orders = array();
    
        foreach ($orders as $order) {
            $billing_email = $order->get_billing_email();
    
            // Check if this email has been encountered before
            if (!isset($latest_orders[$billing_email])) {
                // If not encountered, add this order directly
                $latest_orders[$billing_email] = $order;
            } else {
                // If encountered, compare dates and keep the latest order
                $existing_order = $latest_orders[$billing_email];
                if ($order->get_date_created()->getTimestamp() > $existing_order->get_date_created()->getTimestamp()) {
                    $latest_orders[$billing_email] = $order;
                }
            }
        }

        foreach ($latest_orders as $email => $order) {
            $billing_phone = $order->get_billing_phone();
            $billing_first_name = $order->get_billing_first_name();
            $billing_last_name = $order->get_billing_last_name();
    
            // Proceed with displaying this order's information
            if (!empty($billing_phone) && get_post_meta($order->get_id(), 'sms_consent_order', true) == 'yes') {
                $phone = '<input type="checkbox" data-orderid="' . $order->get_id() . '" value="' . esc_html($billing_phone) . '" name="select_user[]">';
            } else {
                $phone = '<input type="checkbox" value="" disabled>';
            }
    
            echo '<tr>';
            echo '<th scope="row" class="check-column">' . $phone . '</th>';
            echo '<td>' . esc_html($billing_first_name) . '</td>';
            echo '<td>' . esc_html($billing_last_name) . '</td>';
            echo '<td>' . esc_html($email) . '</td>'; // Use $email as we're looping through unique emails
            echo '<td>' . $billing_phone . '</td>';
            echo '<td><button style="cursor:pointer!important" onclick="send_sms_func(' . $order->get_id() . ',' . $billing_phone . ')" class="btn btn-success rounded-pill"><abbr style="cursor:pointer!important" title="Στείλτε στον ' . esc_html($email) . '"><i class="fa-solid fa-comment-sms"></i></abbr></button></td>';
            echo '<td><button style="cursor:pointer!important" onclick="sent_logs_sms_func(' . $order->get_id() . ',' . $role . ')" class="btn btn-success rounded-pill"><abbr style="cursor:pointer!important" title="Στείλτε στον ' . esc_html($email) . '"><i class="fa-solid fa-clock-rotate-left"></i></abbr></button></td>';
            echo '</tr>';
        }
    }else {
        echo '<tr><td style="width:100%!important;position:absolute;text-align:center;font-size:18px;">Δέν υπάρχουν αποτελέσματα</td></tr>';
    }

    echo '</tbody></table>';

    // Pagination
    // $total_users = count_users();
    // $total_pages = ceil($total_users['total_users'] / $users_per_page);

    // $pagination_links = paginate_links(
    //     array(
    //         'base' => add_query_arg('paged', '%#%'),
    //         'format' => '',
    //         'prev_text' => __('&laquo; Previous'),
    //         'next_text' => __('Next &raquo;'),
    //         'total' => $total_pages,
    //         'current' => $current_page,
    //     )
    // );

    // if ($pagination_links) {
    //     echo '<div class="tablenav">';
    //     echo '<div class="tablenav-pages">';
    //     echo $pagination_links;
    //     echo '</div>';
    //     echo '</div>';
    // }

    echo '</div>';
    echo mass_sms_modal_function_guest();
    echo mass_sms_modal_function_singular_guest();
    echo logs_modal();
}