<?php

/// THIS FILE HAS THE WOOCOMMERCE HOOKS AND USER ADMIN CUSTOM FIELD ////
function add_custom_sms_checkbox_to_woo_checkout()
{
    ob_start();

    if (check_sms_consent_status() == true) {
        if (is_user_logged_in()) {
            $current_user_id = get_current_user_id();
            $sms_meta = get_user_meta($current_user_id, 'sms_consent', true);

            ?>

            <label for="sms_consent">
                <?php if ($sms_meta == 'yes') { ?>
                    <input type="checkbox" name="sms_consent" id="sms_consent" checked>
                <?php } else { ?>
                    <input type="checkbox" name="sms_consent" id="sms_consent">
                <?php } ?>
                <?php echo fetch_sms_consent_template(); ?>
            </label>
            <?php
        } else {
            ?>
            <label for="sms_consent">

                <input type="checkbox" name="sms_consent" id="sms_consent" checked>

                <?php echo fetch_sms_consent_template(); ?>
            </label>
            <?php
        }
    }
    echo ob_get_clean();
}

add_filter('woocommerce_review_order_before_submit', 'add_custom_sms_checkbox_to_woo_checkout', 20);
add_action('woocommerce_checkout_update_order_meta', 'save_checkbox_state_to_customer_meta');

function add_custom_meta_field_to_order_edit_screen($order)
{
    ?>
    <div class="form-field">
        <label for="sms_consent_order">
            <input type="checkbox" style="width:unset!important;" name="sms_consent_order" id="sms_consent_order"
                <?php if(get_post_meta($order->get_id(), 'sms_consent_order', true) == 'yes') {echo 'checked';} ?>>
            <?php echo fetch_sms_consent_template(); ?>
        </label>
    </div>
    <?php
}
add_action('woocommerce_admin_order_data_after_billing_address', 'add_custom_meta_field_to_order_edit_screen', 10, 1);

function save_checkbox_state_to_customer_meta($order_id)
{
    $checkbox_state = isset($_POST['sms_consent']) ? 'yes' : 'no';

    if (is_user_logged_in()) {
        $user_id = get_post_meta($order_id, '_customer_user', true);
        update_user_meta($user_id, 'sms_consent', $checkbox_state);
    } else {
        update_post_meta($order_id, 'sms_consent_order', $checkbox_state);

    }
}

add_action('user_register', 'custom_plugin_user_register');

function custom_plugin_user_register($user_id)
{
    add_user_meta($user_id, 'sms_consent', 'no', true);
}


add_action('show_user_profile', 'woo_sms_show_extra_profile_fields');
add_action('edit_user_profile', 'woo_sms_show_extra_profile_fields');

function woo_sms_show_extra_profile_fields($user)
{
    $sms_meta = get_user_meta($user->ID, 'sms_consent', true);
    ?>
    <h3>
        <?php esc_html_e('User SMS Conscent', 'textdomain'); ?>
    </h3>

    <table class="form-table">
        <tr>

            <th><label for="sms_consent">
                    <?php esc_html_e('Sms Conscent', 'textdomain'); ?>
                </label></th>
            <td>

                <?php if ($sms_meta == 'yes') {
                    ?>
                    <input type="checkbox" name="sms_consent" id="sms_consent" value="no" checked>
                    <?php
                } else {
                    ?>
                    <input type="checkbox" name="sms_consent" id="sms_consent" value="yes">
                    <?php
                } ?>

            </td>
        </tr>
    </table>
    <?php
}

add_action('personal_options_update', 'woo_sms_save_extra_profile_fields');
add_action('edit_user_profile_update', 'woo_sms_save_extra_profile_fields');

function woo_sms_save_extra_profile_fields($user_id)
{
    if (current_user_can('edit_user', $user_id)) {
        update_user_meta($user_id, 'sms_consent', sanitize_text_field($_POST['sms_consent']));
    }
}