<?php

function get_presets() {
    global $wpdb;

    $language = defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : 'el';

    $table_name = $wpdb->prefix . 'modulus_woo_sms_templates';

    $templates = $wpdb->get_results("SELECT * FROM ".$table_name." where language ='".$language."'", ARRAY_A);

    $preset_entries = array();
    foreach ($templates as $template) {
        $preset_entry = array(
            'id' => $template['id'], 
            'title' => $template['title'], 
            'message' => $template['message'], 
            'creation_date' => $template['creation_date'], 
            'last_edit_date' => $template['last_edit_date'] 
        );
        $preset_entries[] = $preset_entry;
    }

    return $preset_entries;
}

/*
function get_template_details_from_database($templateId) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'modulus_woo_sms_templates';

    $template = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $templateId), ARRAY_A);

    return $template;
}
*/

//updates table when a new preset is created or an existing one is edited

function update_template_in_database($templateId, $editedTitle, $editedMessage) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'modulus_woo_sms_templates';

    $wpdb->update(
        $table_name,
        array(
            'title' => $editedTitle,
            'message' => $editedMessage,
            'last_edit_date' => current_time('mysql', 1) 
        ),
        array('id' => $templateId),
        array('%s', '%s', '%s'),
        array('%d')
    );
}


add_action('wp_ajax_delete_template', 'delete_template_function');

function delete_template_function() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'modulus_woo_sms_templates';
    
    $templateId = $_POST['template_id'];

    $result = $wpdb->delete($table_name, array('id' => $templateId), array('%d'));

    if ($result === false) {
        
        echo json_encode(array('success' => false, 'message' => 'Failed to delete template.'));
    } else {
        
        echo json_encode(array('success' => true, 'message' => 'Template deleted successfully.'));
    }

    wp_die(); 
}


add_action('wp_ajax_get_template_by_id', 'get_template_by_id_function');

function get_template_by_id_function() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'modulus_woo_sms_templates';
    $templateId = $_POST['template_id'];

  
    $sql = $wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $templateId);
    $templateData = $wpdb->get_row($sql, ARRAY_A);

   
    echo json_encode($templateData);
    wp_die(); 
}


add_action('wp_ajax_update_template', 'update_template_function');

function update_template_function() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'modulus_woo_sms_templates';
    $templateId = $_POST['template_id'];
    $updatedTitle = $_POST['updated_title'];
    $updatedMessage = $_POST['updated_message'];
    $save_type = $_POST['save_type'];

    $current_time = time();

    $language = defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : 'el';

    echo '<script>console.log('.$language.')</script>';

    if($save_type == 'edit'){

        $result = $wpdb->update(
            $table_name,
            array('title' => $updatedTitle, 'message' => $updatedMessage),
            array('id' => $templateId),
            array('%s', '%s'),
            array('%d')
        );

    }else{

           
            $data = array(
                'title' => $updatedTitle,
                'message' => $updatedMessage,
                'language' => $language
            );

          
            $data_format = array(
                '%s', 
                '%s',
                '%s'
            );

           
            $result = $wpdb->insert($table_name, $data, $data_format);
    }

    if ($result === false) {
       
        echo json_encode(array('success' => false, 'message' => 'Failed to update template.'));
    } else {
      
        echo json_encode(array('success' => true, 'message' => 'Template updated successfully.'));
    }

    wp_die(); 
}



