<?php

function custom_user_profile_fields($user) {

    $sms_options = get_presets();
    

    $custom_value = get_user_meta($user->ID, 'custom_meta_key', true);
    ?>
    <div class= "modulus-user-sms">
        <h3>Αποστολή SMS</h3>
        <div style="display: flex; align-items: center;">
        <th><label for="template_options" style="font-weight: bold; margin-right: 85px;">Πρότυπο Μηνύματος</label></th>
        <select id="template_options" name="template_options">
                <option value=""><?php _e('-Επιλέξτε-', 'woo-sms-alerts'); ?></option>
                <?php
                foreach ($sms_options as $value) {
                    echo '<option value="' . esc_attr($value['id']) . '">' . esc_html($value['title']) . '</option>';
                }
                ?>
            </select>
    </div>
            <table class="form-table">
                <tr>
                    <th><label for="message_user_phone style="font-weight: bold;>Τηλέφωνο Παραλήπτη</label></th>
                    <td>
                        <input type="text" name="message_user_phone" id="message_user_phone" class="form-control" style="width: 375px;" value="" />
                    </td>
                </tr>
                <tr>
                    <th><label for="message_user_field style="font-weight: bold;>Μήνυμα</label></th>
                    <td>
                        <textarea name="message_user_field" id="message_user_field" class="regular-text"  style="width: 375px !important; height:200px !important;"><?php echo esc_textarea($custom_value); ?></textarea>
                        
                    </td>
                </tr>
        </table>
        <button class="button button-primary sms-button-user" id="send-sms-button-user">Αποστολή SMS</button><br />
        <span class="description"></span>

    </div>
    
    <script>
     jQuery(document).ready(function($) {
        $('#template_options').on('change', function() {
            var selectedTemplateId = $(this).val();

           
            if (selectedTemplateId !== '') {
                
                $.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    type: 'POST',
                    data: {
                        action: 'get_template_details',
                        templateId: selectedTemplateId
                    },
                    success: function(response) {
                        
                        var trimmedResponse = response.trim();
                        $('#message_user_field').val(trimmedResponse);

                    }
                });
            } else {
                
                $('#message_user_field').val('');
            }
        });
     });
   </script>

<script>
    jQuery(document).ready(function($) {
        $('#message_user_phone').val($('#billing_phone').val());

        $('#send-sms-button-user').on('click', function(e) {
            e.preventDefault();
            var smsMessageuser = $('#message_user_field').val();
            var phoneNumberuser = $('#message_user_phone').val();
            var userID = <?php echo $user->ID; ?>;

          

          
            if (smsMessageuser.trim() === '') {
                
                alert('Please enter a message before sending.');
            } else {
                $.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    method: 'POST',
                    data: {
                        action: 'modulus_customer_send_sms',
                        userId: userID,
                        phoneNumber: phoneNumberuser,
                        message: smsMessageuser
                    },
                    success: function(response) {
                        
                        console.log(response);
                        alert('Message sent!');

                        $('#message_user_field').val('');
                        $('#billing_phone').val('');
                    },
                    error: function(error) {
                        
                        console.error(error);
                    }
                });
            }
        });
    });
</script>
       
 <?php
}

add_action('show_user_profile', 'custom_user_profile_fields');
add_action('edit_user_profile', 'custom_user_profile_fields');


function send_customer_sms_callback() {
    if (isset($_POST['phoneNumber']) && isset($_POST['message'])) {
      
        $phoneNumber = sanitize_text_field($_POST['phoneNumber']);
        // $smsMessage = sanitize_text_field($_POST['message']);
        

        $modulus_settings = woo_sms_alerts_get_sender_settings();

        if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
            $phoneNumber = '30' . $phoneNumber;
        }

        $sender_id = $modulus_settings->sender;
        $api_url_info = $modulus_settings->api_url;
        $routing_info = $modulus_settings->routing_option;
        $api_token = $modulus_settings->api_token;

        $id_user = $_POST['userId'];
        // $phoneNumber = get_user_meta($id, 'billing_phone', true);
        $first_name = get_user_meta($id_user, 'first_name', true);
        $last_name = get_user_meta($id_user, 'last_name', true);
        // $user_name =$first_name .$last_name;
        $placeholders = array("{first_name}", "{last_name}");

        $values = array( $first_name, $last_name);

        $smsreplace = str_replace($placeholders, $values, $_POST['message']);


        $smsMessage = $smsreplace;
        // Prepare SMS data
        if($routing_info == 'sms'){
        $smsData = array(
            'priority' => 3,
            'recipients' => array(
                array(
                    'msisdn' => $phoneNumber
                )
            ),
            'sms' => array(
                'sender' => $sender_id,
                'text' => $smsMessage,
                'encoding' => 'gsm',
                'validityPeriod' => 86400
            ),
            'dlr' => false,
            'dlrUrl' => '',
            'externalTags' => array('string')
        );
    }
    else if($routing_info == 'viber'){

   
        
        $smsData = array(
            'routing'=> 'viber_AmdTelecom_Trans',
            'priority' => 3,
            'recipients' => array(
                array(
                    'msisdn' => $phoneNumber,
                )
            ),
            'viber' => array(
                'sender' => $sender_id,
                'type'=> 'text',
                'text' => $smsMessage,
                'encoding' => 'gsm',
                'validityPeriod' => 86400
            ),
            'dlr' => true,
            'dlrUrl' => 'https://test.gr/callbackmessage',
            'externalTags' => array('string')
        );

    }else if($routing_info == 'viber2sms'){

   
        
        $smsData = array(
            'routing'=> 'viber_AmdTelecom_Trans_SMS',
            'priority' => 3,
            'recipients' => array(
                array(
                    'msisdn' => $phoneNumber,
                )
                
            ),
            'viber' => array(
                'sender' => $sender_id,
                'type'=> 'text',
                'text' => $smsMessage,
                'encoding' => 'gsm',
                'validityPeriod' => 86400
            ),
                'sms' => array(
                    'sender' => $sender_id,
                    'text' => $smsMessage,
                    'encoding' => 'gsm',
                    'validityPeriod' => 86400
            ),
            'dlr' => true,
            'dlrUrl' => 'https://test.gr/callbackmessage',
            'externalTags' => array('string')
        );

    }

        
        $jsonData = json_encode($smsData);

        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url_info);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $api_token
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        curl_close($ch);

       

        echo json_encode(array('success' => true, 'response' => $response, 'httpcode' => $httpcode));
    } else {
        echo json_encode(array('error' => 'Invalid data'));
    }

    wp_die(); 
}

add_action('wp_ajax_modulus_customer_send_sms', 'send_customer_sms_callback'); 
