<?php

function modulus_collect_sms_to_send()
{
    if (fetch_constraints() === 'true') {
        global $wpdb;
        $table_name = $wpdb->prefix . 'modulus_sms_to_send';
        $fetch_sms_to_send = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status= 'todo'"));

        if ($fetch_sms_to_send) {

            foreach ($fetch_sms_to_send as $sms) {

                send_sms_from_cron($sms->id, $sms->phone_number, $sms->message, $sms->type, $sms->order_status_log, $sms->user_id, $sms->order_id);

            }
        }

    }

}

function custom_cron_intervals($schedules)
{
    $schedules['every_two_mins'] = array(
        'interval' => 120,
        'display' => __('Every two minutes'),
    );
    return $schedules;
}

add_filter('cron_schedules', 'custom_cron_intervals');


if (!wp_next_scheduled('modulus_collect_sms_to_send')) {
    wp_schedule_event(time(), 'every_two_mins', 'modulus_collect_sms_to_send');
}

add_action('modulus_collect_sms_to_send', 'modulus_collect_sms_to_send');


function send_sms_from_cron($sms_id, $phoneNumber, $smsMessage, $type, $order_status_log, $id = null, $order_id = null)
{


    $modulus_settings = woo_sms_alerts_get_sender_settings();
    $sender_id = $modulus_settings->sender;
    $api_url_info = $modulus_settings->api_url;
    $routing_info = $modulus_settings->routing_option;
    $api_token = $modulus_settings->api_token;
    if (substr($phoneNumber, 0, 3) !== '+30' && substr($phoneNumber, 0, 2) !== '30') {
        $phoneNumber = '30' . $phoneNumber;
    }

    $smsData = array(
        'priority' => 3,
        'recipients' => array(
            array(
                'msisdn' => $phoneNumber
            )
        ),
        'sms' => array(
            'sender' => $sender_id,
            'text' => $smsMessage,
            'encoding' => 'gsm',
            'validityPeriod' => 86400
        ),
        'dlr' => false,
        'dlrUrl' => '',
        'externalTags' => array('string')
    );


    $jsonData = json_encode($smsData);


    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url_info);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt(
        $ch,
        CURLOPT_HTTPHEADER,
        array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $api_token
        )
    );
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);
    $json_response = json_decode($response);

    if (isset($json_response->messages[0]->messageId)) {
        $messageId = $json_response->messages[0]->messageId;
    }
    update_sms_collector_row($sms_id, 'sent', $messageId);
    if ($type == 'user' || $type == 'mass_order') {
        store_sms_logs_($id, $phoneNumber, $smsMessage, $type, $order_id, $messageId);

    }
    store_sent_sms($order_id, $phoneNumber, $smsMessage, $order_status_log, $messageId, $id, $type);


}

function update_sms_collector_row($row_id, $status, $messageid)
{
    global $wpdb;

    // Define table name
    $table_name = $wpdb->prefix . 'modulus_sms_to_send';
    $data = array(
        'status' => $status,
        'modified' => current_time('mysql', 1),
        'message_id' => $messageid
    );
    $where = array('id' => $row_id);
    // Insert the row into the table
    $wpdb->update($table_name, $data, $where);


}