<?php
/*
Plugin Name: modulus Messaging Platform
Description: Δυνατότητα αποστολής SMS και Viber μηνυμάτων στους πελάτες σας, μεσω του modulus Messaging Platform.
Version: 1.2.4
Author: Modulus
Text Domain: woo-sms-alerts
*/



if (!defined('ABSPATH')) {
    exit;
}


require_once plugin_dir_path(__FILE__) . 'inc/admin.php';
require_once plugin_dir_path(__FILE__) . 'inc/functions.php';
require_once plugin_dir_path(__FILE__) . 'inc/templates.php';
require_once plugin_dir_path(__FILE__) . 'inc/orders.php';
require_once plugin_dir_path(__FILE__) . 'inc/usersms.php';
require_once plugin_dir_path(__FILE__) . 'inc/backinstock.php';
require_once plugin_dir_path(__FILE__) . 'inc/mass_sms/send_mass_sms.php';
require_once plugin_dir_path(__FILE__) . 'inc/woo_sms_alerts_cron.php';


register_activation_hook(__FILE__, 'woo_sms_alerts_install');

function add_styles_header()
{
    if (is_product()) {
        wp_enqueue_style('modulus-front-styles', plugin_dir_url(__FILE__) . 'inc/assets/modulus-front-styles.css', array(), '1.0.0', 'all');

    }

}
add_action('wp_head', 'add_styles_header');
add_action('rest_api_init', function () {
    register_rest_route(
        'modulus-sms-alerts/v1',
        '/callback/',
        array(
            'methods' => 'POST',
            'callback' => 'modulus_sms_alerts_api_callback',
            'permission_callback' => '__return_true',
        )
    );
});

function modulus_sms_alerts_api_callback(WP_REST_Request $request)
{


    $data = $request->get_json_params();



    $messageId = $data['messageId'];
    $apicode = $data['status']['code'];
    $apimessage = $data['status']['message'];



    global $wpdb;
    $table_name = $wpdb->prefix . 'modulus_woo_text_history';

    $result = $wpdb->update(
        $table_name,
        array(
            'callback_code' => $apicode,
            'callback_message' => $apimessage
        ),
        array('message_id' => $messageId),
        array('%d', '%s'),
        array('%s')
    );


    return new WP_REST_Response($messageId, 200);

}


function woo_sms_alerts_install()
{
    global $wpdb;

    $charset_collate = $wpdb->get_charset_collate();
    $table_name = $wpdb->prefix . 'woo_sms_alerts_settings';

    $sql1 = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        api_url varchar(255) NOT NULL,
        routing_option varchar(55) NOT NULL,
        api_token varchar(255) NOT NULL,
        sender varchar(55) NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;";

    $table_name_templates = $wpdb->prefix . 'modulus_woo_sms_templates';
    $sql2 = "CREATE TABLE $table_name_templates (
        id INT NOT NULL AUTO_INCREMENT,
        title TEXT NOT NULL,
        message TEXT NOT NULL,
        language VARCHAR(255) NOT NULL,
        creation_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        last_edit_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (id)
    ) $charset_collate;";

    $table_name_template_back_instock = $wpdb->prefix . 'modulus_woo_sms_backinstock_template';
    $sql_back_in_stock = "CREATE TABLE $table_name_template_back_instock (
    id INT NOT NULL AUTO_INCREMENT,
    title TEXT NOT NULL,
    message TEXT NOT NULL,
    language VARCHAR(255) NOT NULL,
    creation_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_edit_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id)
) $charset_collate;";

    $table_name_orders = $wpdb->prefix . 'modulus_woo_orders_board';
    $sql3 = "CREATE TABLE $table_name_orders (
        id INT NOT NULL AUTO_INCREMENT,
        order_status TEXT NOT NULL,
        sms_sent BOOLEAN NOT NULL,
        order_template INT NOT NULL,
        lang VARCHAR(10) NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;";

    $table_name_text_history = $wpdb->prefix . 'modulus_woo_text_history';
    $sql4 = "CREATE TABLE $table_name_text_history (
        id INT NOT NULL AUTO_INCREMENT,
        order_id INT ,
        phone_number VARCHAR(255) NOT NULL,
        message TEXT NOT NULL,
        sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        order_status_log TEXT NOT NULL,
        message_id TEXT NOT NULL,
        callback_code INT NOT NULL,
        callback_message TEXT NOT NULL,
        user_id INT,
        source VARCHAR(200) NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;";

    $table_name_back_in_stock = $wpdb->prefix . 'modulus_woo_back_in_stock';
    $sql5 = "CREATE TABLE $table_name_back_in_stock (
    id INT NOT NULL AUTO_INCREMENT,
    product_id INT NOT NULL,
    phone_number VARCHAR(255) NOT NULL,
    notify_id INT DEFAULT 0,
    PRIMARY KEY (id)
) $charset_collate;";

    $table_name_sms_constraints_settings = $wpdb->prefix . 'modulus_sms_constraints_settings';

    $sql6 = "CREATE TABLE $table_name_sms_constraints_settings(
    id INT NOT NULL AUTO_INCREMENT,
    constraints LONGTEXT,
    status INT(2) NOT NULL,
    created_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    modified_date TIMESTAMP,
    PRIMARY KEY (id)
) $charset_collate;";

    $table_name_modulus_sms_to_send = $wpdb->prefix . 'modulus_sms_to_send';

    $sql7 = "CREATE TABLE $table_name_modulus_sms_to_send(
    id INT NOT NULL AUTO_INCREMENT,
    phone_number VARCHAR(255) NOT NULL,
    message TEXT NOT NULL,
    user_id INT ,
    order_id INT ,
    type VARCHAR(100) NOT NULL,
    sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    modified TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    message_id TEXT ,
    status VARCHAR(200) DEFAULT 'todo',
    order_status_log TEXT,
    PRIMARY KEY (id)
) $charset_collate;";

    $tale_logs_name = $wpdb->prefix . 'modulus_woo_logs_history';
    $sql8 = "CREATE TABLE $tale_logs_name(
    id INT NOT NULL AUTO_INCREMENT,
    phone_number VARCHAR(255) NOT NULL,
    message TEXT NOT NULL,
    user_id INT ,
    order_id INT ,
    type VARCHAR(100) NOT NULL,
    sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id)
) $charset_collate;";

    $sms_consent_template_table = $wpdb->prefix . 'modulus_sms_consent_template';
    $sms_consent_template_sql = "CREATE TABLE $sms_consent_template_table(
        id INT NOT NULL AUTO_INCREMENT,
        title TEXT NOT NULL,
        text LONGTEXT NOT NULL,
        language VARCHAR(255) NOT NULL,
        creation_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        last_edit_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (id)
        ) $charset_collate;";

    $user_ids = get_users(array('fields' => 'ID'));

    foreach ($user_ids as $user_id) {
        add_user_meta($user_id, 'sms_consent', 'yes', true);
    }


    require_once (ABSPATH . 'wp-admin/includes/upgrade.php');

    dbDelta($sql1);
    dbDelta($sql2);
    dbDelta($sql3);
    dbDelta($sql4);
    dbDelta($sql5);
    dbDelta($sql6);
    dbDelta($sql7);
    dbDelta($sql8);
    dbDelta($sql_back_in_stock);
    dbDelta($sms_consent_template_sql);

    $wpdb->query("TRUNCATE TABLE $table_name_orders");

    $order_statuses = wc_get_order_statuses();



    $order_statuses = wc_get_order_statuses();
    $table_name_sms_constraints_settings_ = $wpdb->prefix . 'modulus_sms_constraints_settings';
    $wpdb->query("TRUNCATE TABLE $table_name_sms_constraints_settings_");
    $data_ = array(
        'status' => 0,
        'constraints' => null,
        'created_date' => current_time('mysql', 1),
        'modified_date' => current_time('mysql', 1),
    );

    $wpdb->insert($table_name_sms_constraints_settings_, $data_);


    if (defined('ICL_SITEPRESS_VERSION')) {

        $languages = apply_filters('wpml_active_languages', NULL, 'orderby=id&order=desc');


        foreach ($languages as $lang_code => $language) {

            foreach ($order_statuses as $slug => $name) {
                $wpdb->insert(
                    $table_name_orders,
                    array(
                        'order_status' => $slug,
                        'sms_sent' => false,
                        'order_template' => 0,
                        'lang' => $lang_code,
                    )
                );
            }
        }
    } else {

        foreach ($order_statuses as $slug => $name) {
            $wpdb->insert(
                $table_name_orders,
                array(
                    'order_status' => $slug,
                    'sms_sent' => false,
                    'order_template' => 0,
                    'lang' => 'el',
                )
            );
        }
    }

}